// Copyright 1997-2000 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.
//
// $Header: /Network/Source/CVS/OmniGroup/Frameworks/OmniHTML/Forms.subproj/OHFormSelect.h,v 1.10 2000/03/25 06:37:07 wjs Exp $

#import <OmniHTML/OHViewCell.h>
#import <OmniHTML/OHFormElementProtocol.h>

@class OHForm, OHFormSelectOption;

@interface OHFormSelect : OHViewCell <OHFormElement>
{
    OHForm *form;
    NSString *name;
    NSArray *options;
    NSMutableArray *selectedOptions;
    OWScriptEventHandlerHolder *eventHandlers;
    NSLock *elementStateLock; // protects options and selectedOptions
}

+ (OHFormSelect *)selectWithForm:(OHForm *)aForm name:(NSString *)aName options:(NSArray *)someOptions visibleRows:(int)aRowCount allowMultiple:(BOOL)shouldAllowMultiple;

// OHFormSelectMultiple overrides these methods
- initWithForm:(OHForm *)aForm name:(NSString *)aName options:(NSArray *)someOptions;

- (NSArray *)options;
- (NSArray *)selectedOptions;
- (void)resetSelectedOptions:(NSArray *)newSelection;

- (OHForm *)form;

@end

@interface OHFormSelect (SubclassesOnly)

- (void)updateUI;
    // Called when the selectedOptions are changed programmatically.  Must be called in the appkit thread

- (void)userDidChangeSelection;
    // Called when the selectedOptions are changed by the user

- (BOOL)allowsMultipleSelection;
    // If YES, there can be from 0..N items selected. If NO, there must be exactly 1 item selected.

@end
