// Copyright 1997-2000 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.

#import <OmniHTML/OHFormSelectOption.h>

#import <Foundation/Foundation.h>
#import <AppKit/AppKit.h>
#import <OmniBase/OmniBase.h>
#import <OmniFoundation/OmniFoundation.h>

RCS_ID("$Header: /Network/Source/CVS/OmniGroup/Frameworks/OmniHTML/Forms.subproj/OHFormSelectOption.m,v 1.5 2000/03/25 06:37:07 wjs Exp $")

@implementation OHFormSelectOption

- init;
{
    if (![super init])
	return nil;

    text = nil;
    tagString = nil;
    initiallySelected = NO;

    return self;
}

- (void)dealloc;
{
    [text release];
    [tagString release];
    [super dealloc];
}

- (NSString *)text;
{
    return text;
}

- (NSString *)tagString;
{
    return tagString ? tagString : text;
}

- (BOOL)initiallySelected;
{
    return initiallySelected;
}

- (void)setText:(NSString *)someText;
{
    if (text == someText)
	return;
    [text release];
    text = [someText retain];
}

- (void)setTagString:(NSString *)aTagString;
{
    if (tagString == aTagString)
	return;
    [tagString release];
    tagString = [aTagString retain];
}

- (void)setInitiallySelected:(BOOL)startsSelected;
{
    initiallySelected = startsSelected;
}

// Debugging

- (NSMutableDictionary *)debugDictionary;
{
    NSMutableDictionary *debugDictionary;

    debugDictionary = [super debugDictionary];
    if (tagString)
        [debugDictionary setObject:tagString forKey:@"tagString"];
    if (text)
	[debugDictionary setObject:text forKey:@"text"];
    [debugDictionary setObject:initiallySelected ? @"YES" : @"NO" forKey:@"initiallySelected"];
    return debugDictionary;
}

@end
