// Copyright 1997-2000 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.
//
// $Header: /Network/Source/CVS/OmniGroup/Frameworks/OmniHTML/Forms.subproj/OHFormText.h,v 1.9 2000/03/25 06:37:08 wjs Exp $

#import <OmniHTML/OHViewCell.h>

@class NSFont, NSTextField;
@class OHForm;
@class OWScriptEventHandlerHolder;

#import <OmniHTML/OHFormElementProtocol.h>
#import <AppKit/NSText.h> // For NSTextAlignment

@interface OHFormText : OHViewCell <OHFormElement>
{
    NSTextField *textField;
    OHForm *form;
    NSString *name;
    NSString *initialValue;
    NSTextAlignment textAlignment;
    unsigned int width, height;
    unsigned int maximumLength;
    struct {
        unsigned int isDisabled:1;
        unsigned int invisibleInput:1;
        unsigned int autoSubmit:1;
    } formTextFlags;
    NSString *currentValue;
    NSLock *elementStateLock;
    OWScriptEventHandlerHolder *eventHandlers;
}

+ (OHFormText *)formTextWithForm:(OHForm *)aForm name:(NSString *)aName value:(NSString *)aValue alignment:(NSTextAlignment)anAlignment disabled:(BOOL)shouldBeDisabled invisibleInput:(BOOL)shouldBeInvisible width:(unsigned int)aWidth height:(unsigned int)aHeight maximumLength:(unsigned int)aMaximumLength;

+ (NSFont *)textFont;
+ (NSRect)textFrameForWidth:(unsigned int)aWidth height:(unsigned int)aHeight;

- initWithForm:(OHForm *)aForm name:(NSString *)aName value:(NSString *)aValue alignment:(NSTextAlignment)anAlignment disabled:(BOOL)shouldBeDisabled invisibleInput:(BOOL)shouldBeInvisible width:(unsigned int)aWidth height:(unsigned int)aHeight maximumLength:(unsigned int)aMaximumLength;

@end

@interface OHFormText (SubclassesOnly)

- (NSView *)setupTextField;
- (void)userDidChangeValue;
- (void)updateUI;

@end
