// Copyright 1997-2000 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.

#import <OmniHTML/OHFormTextArea.h>

#import <Foundation/Foundation.h>
#import <AppKit/AppKit.h>
#import <OmniBase/OmniBase.h>
#import <OmniFoundation/OmniFoundation.h>
#import <OmniAppKit/OmniAppKit.h>

RCS_ID("$Header: /Network/Source/CVS/OmniGroup/Frameworks/OmniHTML/Forms.subproj/OHFormTextArea.m,v 1.12 2000/05/09 22:25:03 kc Exp $")

#import <OmniHTML/OHFormValue.h>

@implementation OHFormTextArea

- (void)dealloc
{
    [[NSNotificationCenter defaultCenter] removeObserver:self];
    [super dealloc];
}

- (NSView *)setupTextField;
{
    NSRect textFrame;
    static const NSSize veryLarge = {1e+30, 1e+30};
    NSScrollView *scrollView;
    NSSize textContainerInset = NSMakeSize(2.0, 0.0);

    //ASSERT_IN_MAIN_THREAD(@"AppKit calls must be from main thread!");
    OBASSERT(!formTextFlags.invisibleInput); // Can't have invisible text areas

    textFrame = NSInsetRect([isa textFrameForWidth:width height:height], -textContainerInset.width, -textContainerInset.height);
    textFrame.origin = NSZeroPoint;
    textView = [[NSTextView alloc] initWithFrame:textFrame];
    [textView setTextContainerInset:textContainerInset];
    [[textView textContainer] setLineFragmentPadding:0];
    [textView setAlignment:textAlignment];
    [textView setVerticallyResizable:YES];
    [textView setDrawsBackground:NO];
    [textView setRichText:NO];
    [textView setFont:[isa textFont]];
    [textView setMaxSize:veryLarge];

    [[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(textDidChange:) name:NSTextStorageDidProcessEditingNotification object:[textView textStorage]];
    [[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(textDidEndEditing:) name:NSTextDidEndEditingNotification object:textView];

    scrollView = [[NSScrollView alloc] initWithFrame:(NSRect){NSZeroPoint, [NSScrollView frameSizeForContentSize:[textView frame].size hasHorizontalScroller:NO hasVerticalScroller:YES borderType:NSBezelBorder]}];
    [scrollView setDocumentView:textView];
    [scrollView setHasVerticalScroller:YES];
    [scrollView setHasHorizontalScroller:NO];
    [scrollView setBorderType:NSBezelBorder];
    [scrollView setBackgroundColor:[NSColor whiteColor]];
    [scrollView freeGStates];

   if (initialValue)
        [textView setString:initialValue];

    [textView release];
    textField = nil;

    return [scrollView autorelease];
}

- (void)textDidChange:(NSNotification *)aNotification
{
    [elementStateLock lock];
    [currentValue release];
    currentValue = [[textView string] copy];
    [elementStateLock unlock];
}

- (void)textDidEndEditing:(NSNotification *)aNotification
{
    [self userDidChangeValue];
}

- (void)updateUI
{
    ASSERT_MAIN_THREAD_OPS_OK(@"AppKit calls must be from main thread!");
    [elementStateLock lock];
    [textView setString:currentValue];
    [elementStateLock unlock];
    [textView sizeToFit];
}

// OAOptionalSearchableCell informal protocol

- (NSView <OASearchableContent> *)searchableContentView;
{
    return textView;
}

// OHFormElement protocol (partial)

- (NSString *)type;
{
    return @"TextArea";
}

@end
