// Copyright 1997-2000 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.
//
// $Header: /Network/Source/CVS/OmniGroup/Frameworks/OmniHTML/Forms.subproj/OHFormValue.h,v 1.4 2000/01/20 00:27:53 kc Exp $

#import <OmniFoundation/OFObject.h>

@class NSData;
@class OWContentType;

typedef enum {
   OHFormValueString, OHFormValueFilename,
} OHFormValueType;

@interface OHFormValue : OFObject
{
    NSString *name;
    NSString *valueString;
    OHFormValueType type;
    id extraState;
}

+ (OHFormValue *)formValueWithName:(NSString *)aName valueString:(NSString *)aString;
+ (OHFormValue *)formValueWithName:(NSString *)aName valueString:(NSString *)aString extraState:extra;
+ (OHFormValue *)formValueWithName:(NSString *)aName valueFilepath:(NSString *)aString;

- initWithName:(NSString *)aName valueString:(NSString *)aString extraState:extra;
- initWithName:(NSString *)aName valueFilepath:(NSString *)aString;
- initWithPropertyList:plist;

- (NSString *)name;
- (OHFormValueType)type;
- (NSString *)valueString;
- extraState;

- (OWContentType *)contentType;
    // Returns the content type of the file represented by a file form element (non-file elements return nil)

- propertyList;

@end
