// Copyright 1997-2000 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.

#import <OmniHTML/OHFormValue.h>

#import <Foundation/Foundation.h>
#import <OmniBase/OmniBase.h>
#import <OmniFoundation/OmniFoundation.h>
#import <OWF/OWF.h>

RCS_ID("$Header: /Network/Source/CVS/OmniGroup/Frameworks/OmniHTML/Forms.subproj/OHFormValue.m,v 1.4 2000/03/25 06:37:08 wjs Exp $")

@implementation OHFormValue

+ (OHFormValue *)formValueWithName:(NSString *)aName valueString:(NSString *)aString;
{
    return [[[self alloc] initWithName:aName valueString:aString extraState:nil] autorelease];
}

+ (OHFormValue *)formValueWithName:(NSString *)aName valueString:(NSString *)aString extraState:extra;
{
    return [[[self alloc] initWithName:aName valueString:aString extraState:extra] autorelease];
}

+ (OHFormValue *)formValueWithName:(NSString *)aName valueFilepath:(NSString *)aString;
{
    return [[[self alloc] initWithName:aName valueFilepath:aString] autorelease];
}


// Init and dealloc

- initWithName:(NSString *)aName valueString:(NSString *)aString extraState:extra;
{
    if (![super init])
	return nil;
    name = [aName retain];
    valueString = [aString retain];
    extraState = [extra retain];
    type = OHFormValueString;
    return self;
}

- initWithName:(NSString *)aName valueFilepath:(NSString *)aString;
{
    if (![super init])
	return nil;
    name = [aName retain];
    valueString = [aString retain];
    extraState = nil;
    type = OHFormValueFilename;
    return self;
}

- initWithPropertyList:plist;
{
    if (![super init])
        return nil;

    name = [[plist objectForKey:@"name"] copy];
    valueString = [[plist objectForKey:@"string"] copy];
    extraState = nil;
    type = OHFormValueString;
    if (!valueString) {
        valueString = [[plist objectForKey:@"path"] copy];
        if (valueString)
            type = OHFormValueFilename;
    }
    
    return self;
}

- (void)dealloc;
{
    [name release];
    [valueString release];
    [extraState release];
    [super dealloc];
}


// API

- (NSString *)name;
{
    return name;
}

- (OHFormValueType)type;
{
    return type;
}

- (NSString *)valueString;
{
    if (valueString)
	return valueString;
    return @"";
}

- extraState
{
    return extraState;
}

- (OWContentType *)contentType;
{
    if (type == OHFormValueFilename)
        return [OWContentType contentTypeForFilename:valueString];
    else
        return nil;
}

- propertyList;
{
    NSMutableDictionary *dictionary;

    dictionary = [NSMutableDictionary dictionary];

    if (name)
        [dictionary setObject:name forKey:@"name"];
    if (valueString) {
        if (type == OHFormValueFilename)
            [dictionary setObject:valueString forKey:@"path"];
        else
            [dictionary setObject:valueString forKey:@"string"];
    }
    
    return dictionary;
}

// Debugging

- (NSMutableDictionary *)debugDictionary;
{
    NSMutableDictionary *debugDictionary;

    debugDictionary = [super debugDictionary];

    if (name)
	[debugDictionary setObject:name forKey:@"name"];
    if (valueString)
	[debugDictionary setObject:valueString forKey:@"valueString"];
    if (extraState)
        [debugDictionary setObject:extraState forKey:@"extraState"];
    switch(type) {
        case OHFormValueString:
            [debugDictionary setObject:@"OHFormValueString" forKey:@"type"];
            break;
        case OHFormValueFilename:
            [debugDictionary setObject:@"OHFormValueFilename" forKey:@"type"];
            break;
        default:
            [debugDictionary setIntValue:type forKey:@"type"];
    }
    
    return debugDictionary;
}

@end
