// Copyright 2000 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.

#import <OmniHTML/OHSubmitFormActionButton.h>

#import <Foundation/Foundation.h>
#import <AppKit/AppKit.h>
#import <OmniBase/OmniBase.h>
#import <OmniFoundation/OmniFoundation.h>
#import <OWF/OWF.h>

#import <OmniHTML/OHForm.h>
#import <OmniHTML/OHFormValue.h>

RCS_ID("$Header: /Network/Source/CVS/OmniGroup/Frameworks/OmniHTML/Forms.subproj/OHSubmitFormActionButton.m,v 1.3 2000/05/25 01:43:54 kc Exp $")

@implementation OHSubmitFormActionButton

- initWithForm:(OHForm *)aForm name:(NSString *)aName value:(NSString *)aValue;
{
    if (!aValue)
        aValue = @"Submit"; // IE 4.0 for Mac has just 'Submit'

    return [super initWithForm:aForm name:aName value:aValue];
}

// API

- (void)setShouldThrob:(BOOL)shouldThrob;
{
    NSView *superview;
    
    superview = [button superview];
    [button removeFromSuperview];
    [button setKeyEquivalent:shouldThrob ? @"\r" : @""];
    [superview addSubview:button];
}

// OHFormActionButton subclass

- (IBAction)performAction:(id)sender;
{
    generatedSubmit = YES;
    [nonretainedForm submit];
}


// OHFormButton subclass

- (NSArray *)formValues;
{
    if (!generatedSubmit)
        return nil;
    generatedSubmit = NO; // Reset for next time

    if (name != nil)
        return [NSArray arrayWithObject:[OHFormValue formValueWithName:name valueString:value]];
    else
        return nil;
}

// OHFormElement protocol (partial)

- (NSString *)type;
{
    return @"Submit";
}

@end
