// Copyright 1997-2000 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.

#import <OmniHTML/OHImageMapCircle.h>

#import <Foundation/Foundation.h>
#import <OmniBase/OmniBase.h>
#import <OmniFoundation/OmniFoundation.h>

RCS_ID("$Header: /Network/Source/CVS/OmniGroup/Frameworks/OmniHTML/ImageMap.subproj/OHImageMapCircle.m,v 1.3 2000/03/25 06:37:09 wjs Exp $")

@implementation OHImageMapCircle

+ (void)didLoad
{
    [self registerClass:self forShapeName:@"circ"];
    [self registerClass:self forShapeName:@"circle"];
}

- (void)setCoordinates:(NSArray *)points;
{
    if ([points count] < 3)
	return;

    center.x = [[points objectAtIndex:0] intValue];
    center.y = [[points objectAtIndex:1] intValue];
    radius = [[points objectAtIndex:2] intValue];
}

- (BOOL)containsPoint:(NSPoint)point;
{
    float 		dx, dy;
    
    dx = point.x - center.x;
    dy = point.y - center.y;
    
    return dx * dx + dy * dy < radius * radius;
}

@end
