// Copyright 1997-2000 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.
//
// $Header: /Network/Source/CVS/OmniGroup/Frameworks/OmniHTML/ImageMap.subproj/OHImageMapCommonCode.h,v 1.4 2000/01/20 00:27:54 kc Exp $

// Note: This code is #imported into two different classes, which is (unfortunately) why it is here.

NAMED_RCS_ID(OHImageMapCommonCode, "$Header: /Network/Source/CVS/OmniGroup/Frameworks/OmniHTML/ImageMap.subproj/OHImageMapCommonCode.h,v 1.4 2000/01/20 00:27:54 kc Exp $");

static OWSGMLTagType *mapTagType;
static OWSGMLTagType *areaTagType;

static unsigned int mapNameAttributeIndex;
static unsigned int areaHrefAttributeIndex;
static unsigned int areaTargetAttributeIndex;

+ (void)didLoad;
{
    OWSGMLDTD *dtd;
    OWSGMLMethods *methods;

    dtd = [self dtd];

    mapTagType = [dtd tagTypeNamed:@"map"];
    areaTagType = [dtd tagTypeNamed:@"area"];

    mapNameAttributeIndex = [mapTagType addAttributeNamed:@"name"];
    areaHrefAttributeIndex = [areaTagType addAttributeNamed:@"href"];
    areaTargetAttributeIndex = [areaTagType addAttributeNamed:@"target"];

    methods = [self sgmlMethods];

    [methods registerMethod:@"Map" forTagName:@"map"];
    [methods registerMethod:@"EndMap" forEndTagName:@"map"];
    [methods registerMethod:@"Area" forTagName:@"area"];
}

- (void)processMapTag:(OWSGMLTag *)tag;
{
    if (!mapSet)
	mapSet = [[OHImageMapSet alloc] init];

    currentMapName = [[tag valueForAttributeAtIndex:mapNameAttributeIndex] retain];
    currentShapes = [[NSMutableArray alloc] init];
}

- (void)processEndMapTag:(OWSGMLTag *)tag;
{
    if (currentMapName && currentShapes)
	[mapSet addShapes:currentShapes forMap:currentMapName];
    [currentShapes release];
    currentShapes = nil;
    [currentMapName release];
    currentMapName = nil;
}

- (void)processAreaTag:(OWSGMLTag *)tag;
{
    OHImageMapShape *shape;
    NSString *href;

    shape = [OHImageMapShape shapeForTag:tag];
    href = [tag valueForAttributeAtIndex:areaHrefAttributeIndex];
    if (href) {
	OWAddress *address;
	NSString *target;

        target = [tag valueForAttributeAtIndex:areaTargetAttributeIndex];
        if (!target)
	    target = [baseAddress target];
	    
	address = [baseAddress addressForRelativeString:href target:target effect:OWAddressEffectFollowInWindow];
	[shape setAddress:address];
    }
    if (shape)
	[currentShapes addObject:shape];

    /* TODO: The <AREA> tag should have the same event handlers as the <A> tag */
}
