// Copyright 1997-2000 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.

#import <OmniHTML/OHImageMapProcessor.h>

#import <Foundation/Foundation.h>
#import <OmniBase/OmniBase.h>
#import <OmniFoundation/OmniFoundation.h>
#import <OmniAppKit/OmniAppKit.h>
#import <OWF/OWF.h>

#import <OmniHTML/OHImageMapSet.h>
#import <OmniHTML/OHImageMapShape.h>

RCS_ID("$Header: /Network/Source/CVS/OmniGroup/Frameworks/OmniHTML/ImageMap.subproj/OHImageMapProcessor.m,v 1.4 2000/03/25 06:37:09 wjs Exp $")

@implementation OHImageMapProcessor

+ (void)didLoad;
{
    [self registerProcessorClass:self fromContentType:[OWContentType contentTypeForString:@"ObjectStream/sgml"] toContentType:[OHImageMapSet contentType] cost:1.0];
}

- (void)dealloc;
{
    [mapSet release];
    [currentShapes release];
    [currentMapName release];
    [super dealloc];
}

- (void)process;
{
    [super process];
    if (mapSet) {
	[pipeline addContent:mapSet];
	[pipeline cacheContent];
	[pipeline startProcessingContent];
    }
}

- (void)processCData:(NSString *)cData;
{
}

@end

@implementation OHImageMapProcessor (Tags)

#import <OmniHTML/OHImageMapCommonCode.h>

@end
