// Copyright 1997-2000 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.

#import <OmniHTML/OHImageMapRectangle.h>

#import <Foundation/Foundation.h>
#import <OmniBase/OmniBase.h>
#import <OmniFoundation/OmniFoundation.h>

RCS_ID("$Header: /Network/Source/CVS/OmniGroup/Frameworks/OmniHTML/ImageMap.subproj/OHImageMapRectangle.m,v 1.3 2000/03/25 06:37:09 wjs Exp $")

@implementation OHImageMapRectangle

+ (void)didLoad
{
    [self registerClass:self forShapeName:@"rect"];
    [self registerClass:self forShapeName:@"rectangle"];
}

- (void)setCoordinates:(NSArray *)points;
{
    int                         left, top, right, bottom;

    if ([points count] < 4)
	return;

    left = [[points objectAtIndex:0] intValue];
    top = [[points objectAtIndex:1] intValue];
    right = [[points objectAtIndex:2] intValue];
    bottom = [[points objectAtIndex:3] intValue];

    rect.origin.x = left;
    rect.origin.y = top;
    rect.size.width = right - left;
    rect.size.height = bottom - top;
}

- (BOOL)containsPoint:(NSPoint)point;
{
    return NSPointInRect(point, rect);
}

// Debugging

- (NSMutableDictionary *)debugDictionary;
{
    NSMutableDictionary *debugDictionary;

    debugDictionary = [super debugDictionary];
    [debugDictionary setObject:NSStringFromRect(rect) forKey:@"rect"];
    return debugDictionary;
}

@end
