// Copyright 1997-2000 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.

#import <OmniHTML/OHImageMapSet.h>

#import <Foundation/Foundation.h>
#import <OmniBase/OmniBase.h>
#import <OmniFoundation/OmniFoundation.h>
#import <OWF/OWF.h>

#import <OmniHTML/OHImageMapShape.h>

RCS_ID("$Header: /Network/Source/CVS/OmniGroup/Frameworks/OmniHTML/ImageMap.subproj/OHImageMapSet.m,v 1.4 2000/03/25 06:37:09 wjs Exp $")

@implementation OHImageMapSet

static OWContentType *contentType;

+ (void)initialize;
{
    static BOOL alreadyInitialized = NO;

    [super initialize];
    if (alreadyInitialized)
        return;
    alreadyInitialized = YES;

    contentType = [[OWContentType contentTypeForString:@"Omni/ImageMapSet"] retain];
}

+ (OWContentType *)contentType;
{
    return contentType;
}

/* TODO: Currently, image maps and map sets aren't zonified */

- init
{
    [super init];
    imageMaps = [[NSMutableDictionary alloc] init];
    
    return self;
}

- (void)dealloc
{
    [imageMaps release];
    [super dealloc];
}

// OWContent protocol

- (OWContentType *)contentType;
{
    return contentType;
}

- (BOOL)shareable;
{
    return YES;
}


//

- (NSArray *)mapNamed:(NSString *)mapName;
{
    return [imageMaps objectForKey:mapName];
}

- (void)addShapes:(NSArray *)shapes forMap:(NSString *)mapName;
{
    [imageMaps setObject:shapes forKey:mapName];
}

@end
