// Copyright 1997-2000 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.

#import <OmniHTML/OHImageMapShape.h>

#import <Foundation/Foundation.h>
#import <OmniBase/OmniBase.h>
#import <OmniFoundation/OmniFoundation.h>
#import <OWF/OWF.h>

#import <OmniHTML/OWSGMLDTD-OHHTMLDTD.h>

RCS_ID("$Header: /Network/Source/CVS/OmniGroup/Frameworks/OmniHTML/ImageMap.subproj/OHImageMapShape.m,v 1.5 2000/03/25 06:37:10 wjs Exp $")

@implementation OHImageMapShape

static NSMutableDictionary *shapeTypes;
static NSMutableCharacterSet *nonCoordinateSet;

+ (void)initialize;
{
    static BOOL initialized = NO;

    [super initialize];
    if (initialized)
	return;
    initialized = YES;

    shapeTypes = [[NSMutableDictionary alloc] init];
    nonCoordinateSet = [[NSCharacterSet decimalDigitCharacterSet] mutableCopy];
    [nonCoordinateSet addCharactersInString:@"-"];
    [nonCoordinateSet invert];
}

static OWSGMLTagType *areaTagType;

static unsigned int areaShapeAttributeIndex;
static unsigned int areaCoordsAttributeIndex;

+ (void)didLoad
{
    OWSGMLDTD *dtd;

    dtd = [OWSGMLDTD OHHTMLDTD];

    areaTagType = [dtd tagTypeNamed:@"area"];

    areaShapeAttributeIndex = [areaTagType addAttributeNamed:@"shape"];
    areaCoordsAttributeIndex = [areaTagType addAttributeNamed:@"coords"];
}

+ (void)registerClass:(Class)aClass forShapeName:(NSString *)shapeName;
{
    [shapeTypes setObject:aClass forKey:[shapeName uppercaseString]];
}

+ (OHImageMapShape *)shapeForTag:(OWSGMLTag *)tag;
{
    NSString *shapeName;
    Class shapeClass;

    shapeName = [sgmlTagValueForAttributeAtIndex(tag, areaShapeAttributeIndex) uppercaseString];
    if (!shapeName)
	shapeName = @"RECT";
    shapeClass = [shapeTypes objectForKey:shapeName];
    return [[[shapeClass alloc] initWithShapeTag:tag] autorelease];
}

- initWithShapeTag:(OWSGMLTag *)tag;
{
    NSString *value;

    [super init];

    if ((value = sgmlTagValueForAttributeAtIndex(tag, areaCoordsAttributeIndex))) {
	NSScanner *scanner;
	NSMutableArray *coordinates;

	scanner = [[NSScanner alloc] initWithString:value];
        [scanner setCharactersToBeSkipped:nonCoordinateSet];
	coordinates = [[NSMutableArray alloc] init];
	while (![scanner isAtEnd]) {
	    int intValue;

	    if (![scanner scanInt:&intValue])
		break;
	    [coordinates addObject:[NSNumber numberWithInt:intValue]];
	}
	[scanner release];
	[self setCoordinates:coordinates];
	[coordinates release];
    }
    return self;
}

- (void)setCoordinates:(NSArray *)points;
{
}

- (BOOL)containsPoint:(NSPoint)point;
{
    return NO;
}

// Debugging

- (NSMutableDictionary *)debugDictionary;
{
    NSMutableDictionary *debugDictionary;

    debugDictionary = [super debugDictionary];
    if (address)
        [debugDictionary setObject:address forKey:@"address"];
    return debugDictionary;
}

@end
