// Copyright 1998-2000 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.

#import <Foundation/Foundation.h>
#import <OmniBase/OmniBase.h>
#import <OmniFoundation/OmniFoundation.h>

#import <OmniHTML/OWContentInfo-Scripting.h>

#import <OmniHTML/OHDocumentProtocol.h>
#import <OmniHTML/OHDocumentFrameProtocol.h>
#import <OmniHTML/OHDocumentViewProtocol.h>
#import <OmniHTML/OWPipeline-ScriptExtensions.h>
#import <OmniHTML/OWScriptDocumentProxy.h>

RCS_ID("$Header: /Network/Source/CVS/OmniGroup/Frameworks/OmniHTML/Scripting.subproj/OWContentInfo-Scripting.m,v 1.5 2000/03/25 06:34:47 wjs Exp $")

@implementation OWContentInfo (Scripting)

// This is a kind of odd place to put the script context (which contains the script interpreter(s)). However, the lifetime of a script context is one appearance of an HTML document. If we make rendered HTML documents non-cacheable, then this corresponds to the lifetime of an OHHTMLPageView and its ContentInfo. Sheesh.

- (OWScriptContext *)scriptContext;
{
    id <OHDocumentFrame> anOpportunisticFrameView;

    if (!scriptContext) {
        if (![nonretainedContent conformsToProtocol:@protocol(OHDocument)]) {
            // Only documents have script contexts, not other kinds of content.
            return nil;
        }
        scriptContext = [[OWScriptContext allocWithZone:[self zone]] initWithOwner:self];
    }

    anOpportunisticFrameView = [[(id <OHDocument>)nonretainedContent omniDocumentView] frameView];
    if (anOpportunisticFrameView)
        [scriptContext setFrame:[anOpportunisticFrameView scriptProxy] hint:NO];

    return scriptContext;
}

- (OWScriptContext *)existingScriptContext;
{
    return scriptContext;
}

- (OWScriptDocumentProxy *)documentProxy;
{
    OWPipeline *documentPipeline;
    OWScriptDocumentProxy *documentProxy;

    [tasksLock lock];
    if ([tasks count] != 0) {
        // As far as I know this assertion is always true (because document content isn't shared between pipelines).  If it isn't, we'll need to choose a particular pipeline somehow.
        OBASSERT([tasks count] == 1);
        documentPipeline = [[tasks objectAtIndex:0] retain];
    } else {
        // This happens if the pipeline has already been deactivated, in which case OnUnload will already have been called, although the scriptContext may not have been torn down yet.
        documentPipeline = nil;
    }
    [tasksLock unlock];

    if (!documentPipeline)
        return nil;

    documentProxy = [documentPipeline scriptProxy];
    [[documentProxy retain] autorelease];
    [documentPipeline release];
    return documentProxy;
}

@end
