// Copyright 1998-2000 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.

#import <OmniHTML/OWPipeline-ScriptExtensions.h>

#import <Foundation/Foundation.h>
#import <OmniBase/OmniBase.h>
#import <OmniFoundation/OmniFoundation.h>
#import <OWF/OWF.h>
#import <OmniHTML/OWScriptDocumentProxy.h>

RCS_ID("$Header: /Network/Source/CVS/OmniGroup/Frameworks/OmniHTML/Scripting.subproj/OWPipeline-ScriptExtensions.m,v 1.4 2000/03/25 06:34:47 wjs Exp $")

@implementation OWPipeline (ScriptExtensions)

static NSString *PipelineScriptProxyContextKey = @"OWPipelineScriptProxy";

- (OWScriptDocumentProxy *)scriptProxy
{
    OWScriptDocumentProxy *documentProxy;
    
    [contextLock lock];
    documentProxy = [context objectForKey:PipelineScriptProxyContextKey];
    if (!documentProxy) {
        documentProxy = [[OWScriptDocumentProxy alloc] initForPipeline:self];
        [context setObject:documentProxy forKey:PipelineScriptProxyContextKey];
        [documentProxy autorelease];
    }
    [contextLock unlock];

    return documentProxy;
}

@end
