// Copyright 1998-2000 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.

#import <OmniHTML/OWScriptBlockProcessor.h>

#import <Foundation/Foundation.h>
#import <OmniBase/OmniBase.h>
#import <OmniFoundation/OmniFoundation.h>
#import <OWF/OWF.h>

RCS_ID("$Header: /Network/Source/CVS/OmniGroup/Frameworks/OmniHTML/Scripting.subproj/OWScriptBlockProcessor.m,v 1.4 2000/03/25 06:34:47 wjs Exp $")

@implementation OWScriptBlockProcessor

static NSMutableDictionary *registeredScriptTypes = nil;
static OWContentType *OWScriptBlockContentType = nil;

+ (void)initialize
{
    [super initialize];

    if (!registeredScriptTypes)
        registeredScriptTypes = [[NSMutableDictionary alloc] init];

    OWScriptBlockContentType = [OWContentType contentTypeForString:@"Omni/ScriptBlock"];
}

+ (void)registerContentType:(OWContentType *)sourceType
                forLanguage:(NSString *)language
{
    [OWProcessor registerProcessorClass:self
                        fromContentType:sourceType
                          toContentType:OWScriptBlockContentType
                                   cost:1.0];

    [registeredScriptTypes setObject:language forKey:sourceType];
}

- (void)process
{
    NSDictionary *theContent;
    id objects[3];
    id keys[3];
    
    [self setStatusString:@"Accumulating script"];

    objects[0] = [dataCursor readAllData];
    keys[0] = @"script";

    objects[1] = [pipeline headerDictionary];
    keys[1] = @"headers";

    objects[2] = [registeredScriptTypes objectForKey:[[dataCursor dataStream] contentType]];
    keys[2] = @"language";

    theContent = [NSDictionary dictionaryWithObjects:objects
                                             forKeys:keys
                                               count: (objects[2])?3:2];

    [pipeline addContent:[OWContentContainer containerWithContent:theContent
                                                      contentType:OWScriptBlockContentType]];
    [pipeline cacheContent];
    [pipeline startProcessingContent];
}
        

@end
