// Copyright 1999-2000 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.
//
// $Header: /Network/Source/CVS/OmniGroup/Frameworks/OmniHTML/Scripting.subproj/OWScriptBlockTarget.h,v 1.2 2000/01/20 00:27:56 kc Exp $

#import <OmniFoundation/OFObject.h>
#import <OWF/OWTargetProtocol.h>

@class NSConditionLock, NSData;
@class OWContentInfo, OWContentType, OWHeaderDictionary;

@interface OWScriptBlockTarget : OFObject <OWTarget>
{
    OWContentInfo *parentContentInfo;
    
    NSConditionLock *resultLock;

    NSData *theScript;
    NSString *scriptLanguage;
    OWHeaderDictionary *scriptHeaders;
}

- initWithParentContentInfo:(OWContentInfo *)pci;

- (NSData *)result;
- (NSString *)resultLanguage;

- (OWContentType *)targetContentType;
- (OWTargetContentDisposition)pipeline:(OWPipeline *)aPipeline
                            hasContent:(id <OWContent>)someContent;


@end


