// Copyright 1997-2000 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.
//
// $Header: /Network/Source/CVS/OmniGroup/Frameworks/OmniHTML/Scripting.subproj/OWScriptContext.h,v 1.13 2000/03/25 06:34:47 wjs Exp $

#import <OWF/OWF.h>
#import <OmniHTML/OWScriptInterpreterProtocol.h>

@class OWScriptFrameProxy, OWScriptDocumentProxy;
@class OHHTMLDocument;

extern NSString *OWScriptContextInvalidationNotification;
extern BOOL OHScriptLanguageCaseInsensitive;

@interface OWScriptContext : OFObject
{
    OWContentInfo *ownerInfo;
    
    NSMutableArray *interpreters;
    NSLock *interpretersLock;
    
    OWScriptFrameProxy *frameProxy;
    BOOL frameProxyIsHint;
    BOOL invalid;
    BOOL hadError;

    OWAddress *baseAddress;
}

+ contextAssociatedWithFrame:(OWScriptFrameProxy *)aFrame;

- initWithOwner:(OWContentInfo *)newOwner;

- (void)setFrame:(OWScriptFrameProxy *)aFrame hint:(BOOL)justAHint;
- (OWScriptFrameProxy *)getFrameHint:(int *)isHint;

- (id <OWScriptInterpreter>)interpreterForLanguage:(NSString *)languageName;

// - (OWScriptFrameProxy *)frameProxy;
- (OWScriptDocumentProxy *)documentProxy;
- (OWContentInfo *)contentInfo;

/* for callbacks specified in HTML attributes. The second form is needed for form elements and links; see the comment in JSInterpreter.h */
- (void)setHandler:(OWScriptEventType)handlerName onObject:anObject toString:(NSString *)handlerCode;
- (void)setHandler:(OWScriptEventType)handlerName onObject:anObject parented:anotherObject toString:(NSString *)handlerCode;

- (void)invalidate;
- (BOOL)isValid;
- (BOOL)hadError;
- (void)setHadError;

- (OWAddress *)baseAddress;
- (void)setBaseAddress:(OWAddress *)newBaseAddress;

@end

