// Copyright 1997-2000 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.
//
// $Header: /Network/Source/CVS/OmniGroup/Frameworks/OmniHTML/Scripting.subproj/OWScriptDocumentProxy.h,v 1.14 2000/03/25 06:34:48 wjs Exp $

#import <Foundation/Foundation.h>
#import <OmniFoundation/OFObject.h>
#import <OmniHTML/OWScriptResponderProtocol.h>
#import <OWF/OWContentProtocol.h>
#import <OmniHTML/OWScriptEvent.h>

@class OWDataStream;
@class OWAddress, OWURL;
@class OWPipeline;
@class OWCookie;
@class OHHTMLDocument;
@class OHColorPalette;
@class OWScriptEventHandlerHolder;

/* OWScriptDocumentProxies actually correspond to OWPipelines in OmniWeb's object model. Most methods access attributes of the pipeline's last content, presumably an OHHTMLDocument, but it's possible for that object to be replaced while the pipline retains its identity (e.g. using the JavaScript document.open() method on an existing document). */

@interface OWScriptDocumentProxy : OFObject <OWScriptResponder>
{
    OWPipeline *nonretainedPipeline;
    id <OWContent> lastPipelineContent;

    NSString *protectionDomain;
    
    BOOL writable;
    OWDataStream *writeBuffer;

    OWScriptEventHandlerHolder *eventHandlers;
    BOOL havePostedLoadEvent;
    BOOL havePostedUnloadEvent;
}


- initForPipeline:(OWPipeline *)aPipe;

- (NSArray *)anchors;  /* array of OHHTMLAnchors */
- (NSArray *)links;    /* array of OHHTMLAnchors */
- (NSArray *)applets;  /* array of OHAppletCells */
- (NSArray *)forms;    /* array of OHForms */
- (NSArray *)images;   /* array of OHInlineImageCells */

- (NSArray *)cookies;  /* array of OWCookies */
- (void)setCookie:(NSString *)cookieDescription;

/* Old-style javascript security. The caller is responsible for making sure the protection domain isn't set to something silly. */
- (NSString *)protectionDomain;
- (void)setProtectionDomain:(NSString *)newDomain;


/* various read-only properties */
- (NSDate *)lastModified;
- (NSString *)title;
- (OHColorPalette *)colorPalette;
- (OWURL *)url;
- (OWAddress *)address;
- (OWAddress *)referringAddress;

/* for talking directly with the document. TODO: should this be eliminated? */
- (OHHTMLDocument *)htmlDocument;

/* document events (OWScriptResponder protocol) */
- (BOOL)handleHTMLEvent:(OWScriptEvent *)event;
- (BOOL)handleHTMLEventsInMainThread;
- (void)setHandler:(id <OWScriptResponder>)handler forEventType:(OWScriptEventType)type;
- (OWScriptEventHandlerHolder *)eventHandlers;

/* a convenience method --- posts an Unload event */
- (void)postUnloadSynchronously;

/* for writable documents */
- (BOOL)isWritable;
- (void)writeData:(NSData *)data;
- (void)setWriteBuffer:(OWDataStream *)strm; /* TODO: invent better mechanism */

@end
