// Copyright 1998-2000 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.
//
// $Header: /Network/Source/CVS/OmniGroup/Frameworks/OmniHTML/Scripting.subproj/OWScriptEvent.h,v 1.10 2000/03/25 06:34:48 wjs Exp $

/* NeXT-gcc bug workaround */
#ifndef OWScriptEvent_H
#define OWScriptEvent_H

/* TODO: Would it be better to make this a protocol? */

#import <OmniFoundation/OmniFoundation.h>
#import <OmniHTML/OWScriptResponderProtocol.h>

@class NSEvent;
@class OFMessageQueue;

typedef enum _OWScriptEventType {
    OWSE_NoEvent = -1,
    OWSE_Abort = 1,
    OWSE_Blur,
    OWSE_Click,
    OWSE_Change,
    OWSE_DblClick,
    OWSE_DragDrop,
    OWSE_Error,
    OWSE_Focus,
    OWSE_KeyDown,
    OWSE_KeyPress,
    OWSE_KeyUp,
    OWSE_Load,
    OWSE_MouseDown,
    OWSE_MouseMove,
    OWSE_MouseEntered,
    OWSE_MouseExited,
    OWSE_MouseUp,
    OWSE_Move,
    OWSE_Reset,
    OWSE_Resize,
    OWSE_Select,
    OWSE_Submit,
    OWSE_Timeout,     /* not an official JavaScript event */
    OWSE_Unload
} OWScriptEventType;

@interface OWScriptEvent : OFObject
{
    OWScriptEventType eventType;

    /* JavaScript-visible properties to have or compute:
         target    String representing the object to which the event was originally sent
         data      dropped URLs for a drag&drop event
    */

//    NSPoint pagePosition;    /* XY position on this page */
    NSEvent *event; // original NS event; may be nil

    id instigator; // the object which created this event

    // An array of objects conforming to OWScriptResponder
    NSMutableArray *possibleResponders;
    int nextPossibleResponder;
    // What to do if the event handlers return YES
    OFInvocation *actionInvocation;
    BOOL actInMainThread;
    // What to do if the event handlers return NO
    OFInvocation *cancelInvocation;
    BOOL cancelInMainThread;
}

+ (OFMessageQueue *)scriptEventQueue;

+ (NSString *)nameForType:(OWScriptEventType)type;

// Convenience method to create and fire off a simple event
+ (void)sendBackgroundEvent:(OWScriptEventType)type instigator:(id)anObject responder:(id <OWScriptResponder>)aResponder;
+ (void)sendBackgroundEvent:(OWScriptEventType)type fromEvent:(NSEvent *)uiEvent instigator:(id)anObject responder:(id <OWScriptResponder>)aResponder;


// Methods to set up the event before it is fired off
- initWithType:(OWScriptEventType)type;
- initWithType:(OWScriptEventType)type fromEvent:(NSEvent *)anEvent;
    // Designated initializer

// Event setup
- (void)setInstigator:(id)myCreator;
- (void)setTarget:(id)finalReceiver action:(SEL)finalAction;
    // convenience method
- (void)setTarget:(id)finalReceiver action:(SEL)finalAction cancelAction:(SEL)cancelAction;
    // convenience method
- (void)setFinalAction:(OFInvocation *)anAction inMainThread:(BOOL)inMain;
- (void)setCancelAction:(OFInvocation *)anAction inMainThread:(BOOL)inMain;
- (void)addResponder:(id <OWScriptResponder>)newResponder;
    // inserts a new responder before the existing ones

// Event information
- (OWScriptEventType)type;
- (id)instigator;
// - (NSPoint)positionOnPage;
- (NSEvent *)nsEvent;

// Called by creator of event to make the event happen
- (void)deliverAsynchronously;
- (BOOL)deliverSynchronously;

// Can be called by handler of event to see what the next responder thinks about it. Returns what -handleHTMLEvent: returned.
- (BOOL)invokeNextHandler;

@end

#endif /* OWScriptEvent_H */
