// Copyright 1997-2000 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.
//
// $Header: /Network/Source/CVS/OmniGroup/Frameworks/OmniHTML/Scripting.subproj/OWScriptInterpreterProtocol.h,v 1.8 2000/03/25 06:34:48 wjs Exp $

/* NeXT-gcc import bug workaround */
#ifndef OWScriptInterpreterProtocol_H
#define OWScriptInterpreterProtocol_H

#import <Foundation/Foundation.h>
#import <OmniHTML/OWScriptEvent.h>

@class OWScriptContext;
@class OWScriptFrameProxy, OWScriptDocumentProxy;

@protocol OWScriptInterpreter <NSObject>

- (BOOL)setLanguage:(NSString *)scriptLanguage;
    // Returns YES if the interpreter can handle the specified language, NO otherwise.

- (NSData *)evaluate:(NSData *)code;
- (NSData *)evaluate:(NSData *)code options:(NSDictionary *)opts;

/* The options dictionary (above) has the following defined keys:
    filename   (string) The name of the file from which the code came
    source     (address) The address of the document from which the code came
    block      (int) The block number within source
    inspect    (bool) Whether to pop up an inspector on the results

    Filename overrides source+block.
*/

// Sometimes the frame isn't known soon enough, but we can guess
- (void)setFrame:(OWScriptFrameProxy *)aFrame hint:(BOOL)isHint;

/* how interpreters are created */
- initWithContext:(OWScriptContext *)nonretainedCtxt;

/* When the context is deallocated */
- (void)invalidateContext;

/* for consistency checks */
- (OWScriptContext *)context;

/* for callbacks specified in HTML attributes */
- (void)setHandler:(OWScriptEventType)handlerName onObject:anObject toString:(NSString *)handlerCode;
- (void)setHandler:(OWScriptEventType)handlerName onObject:anObject parented:anotherObject toString:(NSString *)handlerCode;

@end

#endif /* OWScriptInterpreterProtocol_H */

