// Copyright 1997-2000 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.
//
// $Header: /Network/Source/CVS/OmniGroup/Frameworks/OmniHTML/Support.subproj/OHColorPalette.h,v 1.5 2000/01/20 00:27:58 kc Exp $

#import <OmniFoundation/OFObject.h>

@class NSColor;

typedef enum {
    OHColorPaletteBackgroundIndex, OHColorPaletteTextIndex,
    OHColorPaletteLinkIndex, OHColorPaletteVisitedLinkIndex, OHColorPaletteActiveLinkIndex,
    OHColorPaletteExtraIndex,
    OHColorPaletteIndexCount
} OHColorPaletteIndex;

extern const OHColorPaletteIndex OHColorPaletteFirstIndex;

@interface OHColorPalette : OFObject
{
    NSColor *colorArray[OHColorPaletteIndexCount];
    BOOL hasExtraColor;
}

+ (OHColorPalette *)defaultPalette;
+ (void)setAlwaysUsePreferenceColors:(BOOL)shouldAlwaysUsePreferenceColors;

+ (NSColor *)colorForString:(NSString *)colorString;
+ (NSString *)stringForColor:(NSColor *)color;

- (id)copy;
- (id)copyWithZone:(NSZone *)newZone;

- (NSColor *)backgroundColor;
- (NSColor *)textColor;
- (NSColor *)linkColor;
- (NSColor *)visitedLinkColor;
- (NSColor *)activeLinkColor;

- (void)setBackgroundColor:(NSColor *)aColor;
- (void)setTextColor:(NSColor *)aColor;
- (void)setLinkColor:(NSColor *)aColor;
- (void)setVisitedLinkColor:(NSColor *)aColor;
- (void)setActiveLinkColor:(NSColor *)aColor;
- (void)setExtraColor:(NSColor *)aColor;
- (void)unsetExtraColor;

- (NSColor *)anchorColor; // Just in case

- (NSColor * const *)colorArray;
- (NSColor *)colorAtColorIndex:(OHColorPaletteIndex)colorIndex;

@end

@class OWSGMLTag;

@interface OHColorPalette (ColorTag)
- (id)copyWithChangesFromTag:(OWSGMLTag *)tag
  bgColorAttributeIndex:(unsigned int)bgColorAttributeIndex
  textAttributeIndex:(unsigned int)textAttributeIndex
  linkAttributeIndex:(unsigned int)linkAttributeIndex
  vlinkAttributeIndex:(unsigned int)vlinkAttributeIndex
  alinkAttributeIndex:(unsigned int)alinkAttributeIndex;
@end
