// Copyright 1998-2000 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.
//
// $Header: /Network/Source/CVS/OmniGroup/Frameworks/OmniHTML/Support.subproj/OHDocumentFrameProtocol.h,v 1.4 2000/02/24 00:00:30 kc Exp $

#import <Foundation/NSObject.h>

@class NSEvent;
@class OWAddress;
@class OWScriptFrameProxy;

#import <Foundation/NSGeometry.h> // For NSRect

@protocol OHDocumentFrame <NSObject>

// Selecting and following links

- (void)documentViewSelectionDidChange;
    // Documents call this method when their selectedLink changes.

- (void)displayDocumentAtAddress:(OWAddress *)anAddress;
    // Display the document at the specified address.  Documents ask the frame to display a new address when a hypertext link is followed.

// Active frame

- (void)becomeActiveFrame;
    // When a document view becomes the first responder, it lets its frame know that it is now the active frame.
- (void)resignActiveFrame;
    // When a document view resigns from being first responder, it lets its frame know that it is no longer the active frame.

// Utility methods

- (void)drawFrameBorderForDocumentView:(NSView *)aDocumentView rect:(NSRect)aRect;
    // A document view will call this in its -drawRect: to draw the frame's highlight border over itself.

- (void)documentViewKeyDown:(NSEvent *)keyDownEvent;
    // This handles common keystrokes like arrow keys, page up, page down, etc.

// Scripting

- (OWScriptFrameProxy *)scriptProxy;

@end
