// Copyright 1997-2000 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.

#import <OmniHTML/OHDocumentView.h>

#import <Foundation/Foundation.h>
#import <OmniBase/OmniBase.h>
#import <OmniFoundation/OmniFoundation.h>
#import <OmniAppKit/OmniAppKit.h>
#import <OWF/OWF.h>

#import <OmniHTML/OHColorPalette.h>
// #import <OmniHTML/OWFrameView.h>

RCS_ID("$Header: /Network/Source/CVS/OmniGroup/Frameworks/OmniHTML/Support.subproj/OHDocumentView.m,v 1.3 2000/03/25 06:34:48 wjs Exp $")

@implementation OHDocumentView

static NSString *contentTypeString;
static OWContentType *contentType;

+ (void)initialize
{
    static BOOL initialized = NO;

    [super initialize];
    if (initialized)
        return;
    initialized = YES;

    contentTypeString = [@"omni/document" retain];
    contentType = [OWContentType contentTypeForString:contentTypeString];
}

+ (NSString *)contentTypeString;
{
    return contentTypeString;
}

+ (OWContentType *)contentType;
{
    return contentType;
}


// Init and dealloc

- initWithFrame:(NSRect)frameRect;
{
    if (![super initWithFrame:frameRect])
	return nil;

    nonretainedFrameView = nil;
    backgroundColor = [[[OHColorPalette defaultPalette] backgroundColor] retain];

    return self;
}

- (void)dealloc;
{
    [contentInfo nullifyContent];
    [contentInfo release];
    
    [backgroundColor release];
    [super dealloc];
}


// NSResponder

- (BOOL)acceptsFirstResponder;
{
    return YES;
}

- (BOOL)becomeFirstResponder;
{
    [nonretainedFrameView becomeActiveFrame];
    return YES;
}

- (BOOL)resignFirstResponder;
{
    [nonretainedFrameView resignActiveFrame];
    return YES;
}

- (void)keyDown:(NSEvent *)theEvent;
{
    [nonretainedFrameView documentViewKeyDown:theEvent];
}


// NSView

- (BOOL) isFlipped;
{
    return YES;
}

- (void)drawRect:(NSRect)rect
{
    [backgroundColor set];
    NSRectFill(rect);
}


// Info

// OHDocument protocol

- (NSView <OHDocumentView> *)omniDocumentView;
{
    return self;
}

// OWContent protocol

- (OWContentType *)contentType;
{
    return contentType;
}

- (OWContentInfo *)contentInfo;
{
   return contentInfo;
}

// OHDocumentView protocol

- (void)setFrameView:(id <OHDocumentFrame>)aFrame;
{
    nonretainedFrameView = aFrame;
}

- (id <OHDocumentFrame>)frameView;
{
    return [[nonretainedFrameView retain] autorelease];
}

- (BOOL)wantsScrollers;
{
    return YES;
}

// Debugging

- (NSMutableDictionary *)debugDictionary;
{
    NSMutableDictionary *debugDictionary;

    debugDictionary = [super debugDictionary];
    if (backgroundColor)
        [debugDictionary setObject:backgroundColor forKey:@"backgroundColor"];
    if (contentInfo)
        [debugDictionary setObject:contentInfo forKey:@"contentInfo"];
    return debugDictionary;
}

@end
