// Copyright 1997-2000 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.
//
// $Header: /Network/Source/CVS/OmniGroup/Frameworks/OmniHTML/Support.subproj/OHDocumentViewProtocol.h,v 1.9 2000/03/25 06:34:48 wjs Exp $

#ifndef _OHDocumentViewProtocolDefined_
// Doing this #ifdef/#define to avoid warnings when importing both the installed project header and the one in the source directory.
#define _OHDocumentViewProtocolDefined_

#import <Foundation/NSObject.h>

@class OWAddress, OWFrameView;

#import <OmniHTML/OHDocumentFrameProtocol.h>

@protocol OHDocumentView <NSObject>

- (void)setFrameView:(id <OHDocumentFrame>)aFrame;
- (id <OHDocumentFrame>)frameView;

- (BOOL)wantsScrollers;
    // Whether the document wants to be displayed in a scrollview

@end

#import <AppKit/NSNibDeclarations.h> // For IBOutlet, IBAction

@protocol OHOptionalDocumentView <OHDocumentView>

- (IBAction)saveAs:(id)sender;

- (OWAddress *)selectedAddress;
- (void)selectNextLink;
- (void)selectPreviousLink;
- (void)selectFirstKeyView;
- (void)selectLastKeyView;
- (BOOL)followSelectedLink;
- (void)scrollToAnchorNamed:(NSString *)anchorName;
- (void)noDisplaySelectAnchorWithAddress:(OWAddress *)anAddress;
- (void)documentDisplayedInNewFrame;

// Dragging help
- (NSPoint)draggingStartingLocationInWindow;

@end

#endif
