// Copyright 1997-2000 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.
//
// $Header: /Network/Source/CVS/OmniGroup/Frameworks/OmniHTML/Support.subproj/OHDownloader.h,v 1.8 2000/03/25 06:34:48 wjs Exp $

#import <OmniFoundation/OFObject.h>

@class NSConditionLock, NSWindow;
@class OWAddress, OWDataStream;

#import <OWF/OWTargetProtocol.h>

@interface OHDownloader : OFObject <OWTarget>
{
    NSString *requiredFilename;
    NSString *requiredDirectoryPath;
    OWDataStream *dataStream;
    NSConditionLock *dataStreamStatusLock;
    BOOL shouldPresent;
    BOOL shouldLaunch;
}
    // Handy little utility method.
+ (NSString *)suggestedFilenameForAddress:(OWAddress *)address;
+ (NSString *)runSavePanelOnAddress:(OWAddress *)address asFileType:(NSString *)fileType relativeToWindow:(NSWindow*)window;

+ (NSString *)downloadDirectoryPath;
+ (void)downloadAddressAndPromptForFilename:(OWAddress *)address relativeToWindow:(NSWindow*)window;

// Init and dealloc
+ (OHDownloader *)downloader;
+ (OHDownloader *)downloaderOpenWorkspaceOnFileFromAddress:(OWAddress *)address;
+ (OHDownloader *)downloaderDownloadingAddressNoPresent:(OWAddress *)address;

//
- (void)setRequiredFilename:(NSString *)filename;
- (void)setRequiredDirectoryPath:(NSString *)directoryPath;

- (void)setPresentsWhenFinished:(BOOL)presentFlag;
- (void)setLaunchWhenFinished:(BOOL)launchFlag;
- (NSString *)filename;
- (void)blockUntilDownloadComplete;

@end

#import <OmniHTML/FrameworkDefines.h>

OmniHTML_EXTERN NSString *OHDownloaderStartedNotification;
    // This is posted when a download starts.
OmniHTML_EXTERN NSString *OHDownloaderFinishedNotification;
    // This is posted when a download successfully completes.
OmniHTML_EXTERN NSString *OHDownloaderAbortedNotification;
    // This is posted when a download fails.

OmniHTML_EXTERN NSString *OHDownloaderTaskHeaderName;
    // The task header string used by the downloader
