// Copyright 1997-2000 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.
//
// $Header: /Network/Source/CVS/OmniGroup/Frameworks/OmniHTML/Support.subproj/OHWidthRange.h,v 1.5 2000/01/20 00:27:59 kc Exp $

#import <OmniBase/assertions.h>

typedef struct {
    unsigned int minimum;
    unsigned int maximum;
} OHWidthRange;

#define ASSERT_WIDTHRANGE_IS_VALID(widthRange) OBASSERT(widthRange.minimum <= widthRange.maximum)

static inline OHWidthRange OHMakeWidthRange(unsigned int minimum, unsigned int maximum)
{
    OHWidthRange newRange;

    newRange.minimum = minimum;
    newRange.maximum = maximum;
    ASSERT_WIDTHRANGE_IS_VALID(newRange);
    return newRange;
}

static inline OHWidthRange OHAddWidthToWidthRange(unsigned int width, OHWidthRange widthRange)
{
    widthRange.minimum += width;
    widthRange.maximum += width;
    ASSERT_WIDTHRANGE_IS_VALID(widthRange);
    return widthRange;
}

static inline OHWidthRange OHMaximumWidthRange(OHWidthRange a, OHWidthRange b)
{
    if (b.minimum > a.minimum)
        a.minimum = b.minimum;
    if (b.maximum > a.maximum)
        a.maximum = b.maximum;
    ASSERT_WIDTHRANGE_IS_VALID(a);
    return a;
}

static inline OHWidthRange OHAddWidthRanges(OHWidthRange a, OHWidthRange b)
{
    a.minimum += b.minimum;
    a.maximum += b.maximum;
    ASSERT_WIDTHRANGE_IS_VALID(a);
    return a;
}

static inline BOOL OHWidthInWidthRange(int width, OHWidthRange widthRange)
{
    ASSERT_WIDTHRANGE_IS_VALID(widthRange);
    return width >= widthRange.minimum && width <= widthRange.maximum;
}

static inline BOOL OHWidthIsGreaterThanOrEqualToMinimumWidthInRange(int width, OHWidthRange widthRange)
{
    ASSERT_WIDTHRANGE_IS_VALID(widthRange);
    return width >= widthRange.minimum;
}

#import <Foundation/NSString.h>

static inline NSString *OHStringFromWidthRange(OHWidthRange aRange)
{
    ASSERT_WIDTHRANGE_IS_VALID(aRange);
    return [NSString stringWithFormat:@"[%d - %d]", aRange.minimum, aRange.maximum];
}
