// Copyright 1998-2000 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.
//
// $Header: /Network/Source/CVS/OmniGroup/Frameworks/OmniHTML/Support.subproj/OWAddress-OHActions.h,v 1.5 2000/03/25 06:34:48 wjs Exp $

#import <OWF/OWAddress.h>

#import <Foundation/NSGeometry.h> // For NSPoint

@interface OWAddress (AppSupport)

- (void)addToBookmarks;
    // This method posts an OWAddressAddToBookmarksNotification to cause the address to be bookmarked.

- (void)openDocumentInNewWindow;
    // This method posts an OWAddressOpenInNewWindowNotification to cause the address to be opened in a new window.

- (void)openDocumentInNewWindowAtScreenPoint:(NSPoint)screenPoint;
    // This method posts an OWAddressOpenInNewWindowNotification to cause the address to be opened in a new window at the specified screen point.

- (void)startDraggingDocumentInNewWindowAtScreenPoint:(NSPoint)screenPoint;
    // This method posts an OWAddressOpenInNewWindowNotification to cause the address to be opened in a new window being dragged at the specified screen point.

@end

#import <OmniHTML/FrameworkDefines.h>

OmniHTML_EXTERN NSString *OWAddressAddToBookmarksNotification;
    // This notification is posted by the -addToBookmarks method to actually add the address to the user's bookmarks.

OmniHTML_EXTERN NSString *OWAddressOpenDocumentInNewWindowNotification;
    // This notification is posted by the -openDocumentInNewWindow and -openDocumentInNewWindowAtScreenPoint: methods.  The application should be listening for this notification, and open the window as requested.

OmniHTML_EXTERN NSString *OWAddressOpenDocumentInNewWindowScreenPointKey;
    // The new window's screen point is held in an NSValue under this key.  (If this key isn't present, no specific screen point was requested.)

OmniHTML_EXTERN NSString *OWAddressOpenDocumentInNewWindowStartDraggingKey;
    // This specifies whether the newly opened document is being dragged by the user.
