// Copyright 1998-2000 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.

#import <OmniHTML/OWAddress-OHActions.h>

#import <Foundation/NSString.h>
#import <Foundation/Foundation.h>
#import <OmniBase/OmniBase.h>
#import <OmniFoundation/OmniFoundation.h>
#import <OWF/OWF.h>

RCS_ID("$Header: /Network/Source/CVS/OmniGroup/Frameworks/OmniHTML/Support.subproj/OWAddress-OHActions.m,v 1.5 2000/03/25 06:34:48 wjs Exp $")

@implementation OWAddress (AppSupport)

- (void)addToBookmarks;
{
    [[NSNotificationCenter defaultCenter] postNotificationName:OWAddressAddToBookmarksNotification object:self];
}

- (void)openDocumentInNewWindow;
{
    [[NSNotificationCenter defaultCenter] postNotificationName:OWAddressOpenDocumentInNewWindowNotification object:self];
}

- (void)openDocumentInNewWindowAtScreenPoint:(NSPoint)screenPoint;
{
    NSMutableDictionary *userInfoDictionary;

    userInfoDictionary = [[NSMutableDictionary alloc] initWithCapacity:1];
    [userInfoDictionary setObject:[NSValue valueWithPoint:screenPoint] forKey:OWAddressOpenDocumentInNewWindowScreenPointKey];
    [[NSNotificationCenter defaultCenter] postNotificationName:OWAddressOpenDocumentInNewWindowNotification object:self userInfo:userInfoDictionary];
}

- (void)startDraggingDocumentInNewWindowAtScreenPoint:(NSPoint)screenPoint;
{
    NSMutableDictionary *userInfoDictionary;

    userInfoDictionary = [[NSMutableDictionary alloc] initWithCapacity:2];
    [userInfoDictionary setObject:[NSValue valueWithPoint:screenPoint] forKey:OWAddressOpenDocumentInNewWindowScreenPointKey];
    [userInfoDictionary setBoolValue:YES forKey:OWAddressOpenDocumentInNewWindowStartDraggingKey];
    [[NSNotificationCenter defaultCenter] postNotificationName:OWAddressOpenDocumentInNewWindowNotification object:self userInfo:userInfoDictionary];
}

@end

DEFINE_NSSTRING(OWAddressOpenDocumentInNewWindowNotification);
DEFINE_NSSTRING(OWAddressOpenDocumentInNewWindowScreenPointKey);
DEFINE_NSSTRING(OWAddressOpenDocumentInNewWindowStartDraggingKey);
DEFINE_NSSTRING(OWAddressAddToBookmarksNotification);
