// Copyright 1997-2000 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.
//
// $Header: /Network/Source/CVS/OmniGroup/Frameworks/OmniHTML/Support.subproj/OWAddress-OHDragging.h,v 1.3 2000/01/20 00:27:59 kc Exp $

#import <OWF/OWAddress.h>

@class NSEvent, NSImage, NSView;
@class OAPasteboardHelper;
@class OIImage;

#import <Foundation/NSGeometry.h> // For NSPoint

@interface OWAddress (Dragging)

- (void)startDragFromView:(NSView *)view image:(NSImage *)image atPoint:(NSPoint)location event:(NSEvent *)event pasteboardHelper:(OAPasteboardHelper *)pasteboardHelper;
    // Drags an address.  Checks the event to see whether this is a normal URL drag, a drag to create a new window (alt-drag), or a drag to download (command-drag).

- (void)startDragFromView:(NSView *)view atPoint:(NSPoint)location event:(NSEvent *)event;
    // Calls -startDragFromView:image:atPoint:event:pasteboardHelper:, calculating the missing parameters.

- (void)startDragOmniImage:(OIImage *)omniImage imageAddress:(OWAddress *)imageAddress fromView:(NSView *)aView event:(NSEvent *)event;
    // Drags an image.


@end

