// Copyright 1997-2000 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.

#import <OmniHTML/OWAddress-OHDragging.h>

#import <Foundation/Foundation.h>
#import <AppKit/AppKit.h>
#import <OmniBase/OmniBase.h>
#import <OmniFoundation/OmniFoundation.h>
#import <OmniAppKit/OmniAppKit.h>
#import <OWF/OWF.h>
#import <OIF/OIF.h>

#import <OmniHTML/OHHTMLView.h>
#import <OmniHTML/OWAddress-OHActions.h>
#import <OmniHTML/OWAddress-OHImage.h>
#import <OmniHTML/OWAddress-OHPasteboard.h>

RCS_ID("$Header: /Network/Source/CVS/OmniGroup/Frameworks/OmniHTML/Support.subproj/OWAddress-OHDragging.m,v 1.12 2000/05/09 22:40:36 kc Exp $")

@implementation OWAddress (Dragging)

- (void)startDragFromView:(NSView *)view image:(NSImage *)image atPoint:(NSPoint)location event:(NSEvent *)event pasteboardHelper:(OAPasteboardHelper *)pasteboardHelper;
{
    NSString *localFilename = nil;

    if ((localFilename = [self localFilename])) {
        [pasteboardHelper addTypes:[NSArray arrayWithObject:NSFilenamesPboardType] owner:self];
        pasteboardFilename = [localFilename retain];
    } 

    if (([event modifierFlags] & NSAlternateKeyMask) != 0) {
        [self startDraggingDocumentInNewWindowAtScreenPoint:[[event window] convertBaseToScreen:[event locationInWindow]]];
        return;
    } else if ([self representsFile] && ([event modifierFlags] & NSCommandKeyMask) != 0) {
#warning Should change the drag image to indicate a download vs. normal drag
        [pasteboardHelper declareTypes:[NSArray arrayWithObject:NSFilenamesPboardType] owner:self];
#ifdef CREATE_URL_FILES_WHEN_DRAGGING_LINKS
    } else if (!(localFilename || [[[pasteboardHelper pasteboard] types] containsObject:NSFilenamesPboardType])) {
        NSData *urlFileData;
        NSString *filename, *path;
        // Defaults to making a .url file.

        path = [[[[NSUserDefaults standardUserDefaults] stringForKey:@"OHDownloadFolder"] stringByExpandingTildeInPath] stringByAppendingString:@"/"];
        filename = [[path stringByAppendingString:[self bestKnownTitle]] stringByAppendingString:@".url"];
        urlFileData = [[NSData alloc] initWithData:[[self addressString] dataUsingEncoding:NSASCIIStringEncoding]];
        
        if ([urlFileData writeToFile:filename atomically:YES]) {
            [pasteboardHelper addTypes:[NSArray arrayWithObject:NSFilenamesPboardType] owner:self];
            pasteboardFilename = [filename retain];
        }

        [urlFileData release];
#endif
    }

    [[OADragController sharedDragController] startDragFromView:view image:image atPoint:location offset:NSZeroPoint event:event slideBack:YES pasteboardHelper:pasteboardHelper delegate:self];
}

- (void)startDragFromView:(NSView *)view atPoint:(NSPoint)location event:(NSEvent *)event;
{
    OAPasteboardHelper *pasteboardHelper;

    pasteboardHelper = [OAPasteboardHelper helperWithPasteboardNamed:NSDragPboard];
    [pasteboardHelper declareTypes:[self exportedPasteboardTypes] owner:self];
    [self startDragFromView:view image:[self dragImage] atPoint:location event:event pasteboardHelper:pasteboardHelper];
}

- (void)startDragOmniImage:(OIImage *)omniImage imageAddress:(OWAddress *)imageAddress fromView:(NSView *)aView event:(NSEvent *)event;
{
    NSImage *dragImage;
    NSSize dragImageSize;
    OAPasteboardHelper *pasteboardHelper;
    NSPoint where;

    where = [aView convertPoint:[event locationInWindow] fromView:nil];

    dragImageSize = [[omniImage image] size];
    dragImage = [[NSImage alloc] initWithSize:dragImageSize];
    [dragImage lockFocus]; {

        // Draw transparent background
        [[NSColor colorWithDeviceWhite:1.0 alpha:0.0] set];
        NSRectFill(NSMakeRect(0, 0, dragImageSize.width, dragImageSize.height));

        // Draw icon
        [[omniImage image] dissolveToPoint:NSZeroPoint fraction:0.5];

    } [dragImage unlockFocus];

    where.x -= rint(dragImageSize.width / 2.0);
    where.y += rint(dragImageSize.height / 2.0);

    pasteboardHelper = [OAPasteboardHelper helperWithPasteboardNamed:NSDragPboard];
    [pasteboardHelper declareTypes:[self exportedPasteboardTypes] owner:self];

    if (omniImage)
        [pasteboardHelper addTypes:[NSArray arrayWithObject:NSTIFFPboardType] owner:omniImage];
    if ([imageAddress localFilename] != nil)
        [pasteboardHelper addTypes:[NSArray arrayWithObject:NSFilenamesPboardType] owner:imageAddress];

    [self startDragFromView:aView image:dragImage atPoint:where event:event pasteboardHelper:pasteboardHelper];
}

@end
