// Copyright 1997-2000 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.

#import <OmniHTML/OWAddress-OHImage.h>

#import <Foundation/Foundation.h>
#import <AppKit/AppKit.h>
#import <OmniBase/OmniBase.h>
#import <OmniFoundation/OmniFoundation.h>
#import <OmniAppKit/OmniAppKit.h>
#import <OWF/OWF.h>

RCS_ID("$Header: /Network/Source/CVS/OmniGroup/Frameworks/OmniHTML/Support.subproj/OWAddress-OHImage.m,v 1.10 2000/05/24 07:56:55 kc Exp $")

@interface OHUnusedClass : NSObject
@end

@implementation OHUnusedClass
@end

@implementation OWAddress (OHImage)

static BOOL ImagesSetup = NO;
static NSImage *URLImage = nil;
static NSImage *URLBookmarkImage = nil;
static NSImage *URLIndexImage = nil;
static NSImage *SecureURLImage = nil;
static NSImage *GeneratedURLImage = nil;
static NSImage *SecureGeneratedURLImage = nil;
static NSImage *GrayURLImage = nil;
static NSImage *GrayURLBookmarkImage = nil;
static NSImage *GrayURLIndexImage = nil;
static NSImage *GraySecureURLImage = nil;
static NSImage *GrayGeneratedURLImage = nil;
static NSImage *GraySecureGeneratedURLImage = nil;
static NSDictionary *titleFontAttributes;

+ (void)setupImages;
{
    NSFont *addressFont;
    NSBundle *bundle;

    bundle = [NSBundle bundleForClass:[OHUnusedClass class]]; // Can't use self because OWAddress is from OWF, not OmniHTML.
    URLImage = [[NSImage alloc] initWithContentsOfFile:[bundle pathForImageResource:@"URL"]];
    SecureURLImage = [[NSImage alloc] initWithContentsOfFile:[bundle pathForImageResource:@"URL_Secure"]];
    GeneratedURLImage = [[NSImage alloc] initWithContentsOfFile:[bundle pathForImageResource:@"URL_Generated"]];
    SecureGeneratedURLImage = [[NSImage alloc] initWithContentsOfFile:[bundle pathForImageResource:@"URL_Secure_Generated"]];
    URLBookmarkImage = [[NSImage alloc] initWithContentsOfFile:[bundle pathForImageResource:@"URL_OpenBook"]];
    URLIndexImage = [[NSImage alloc] initWithContentsOfFile:[bundle pathForImageResource:@"URL_OpenIndex"]];
    GrayURLImage = [[NSImage alloc] initWithContentsOfFile:[bundle pathForImageResource:@"URLGray"]];
    // Don't have these images yet
    GraySecureURLImage = SecureURLImage;
    GrayGeneratedURLImage = GeneratedURLImage;
    GraySecureGeneratedURLImage = SecureGeneratedURLImage;
    GrayURLBookmarkImage = URLBookmarkImage;
    GrayURLIndexImage = URLIndexImage;

    addressFont = [NSFont boldSystemFontOfSize:12.0];
    if (!addressFont)
        addressFont = [NSFont fontWithName:@"Helvetica" size:12.0];
    titleFontAttributes = [[NSDictionary alloc] initWithObjectsAndKeys:addressFont, NSFontAttributeName, [NSColor textColor], NSForegroundColorAttributeName, nil];

    OBPOSTCONDITION(URLImage != nil);
    OBPOSTCONDITION(SecureURLImage != nil);
    OBPOSTCONDITION(GeneratedURLImage != nil);
    OBPOSTCONDITION(SecureGeneratedURLImage != nil);
    OBPOSTCONDITION(URLBookmarkImage != nil);
    OBPOSTCONDITION(URLIndexImage != nil);
    OBPOSTCONDITION(GrayURLImage != nil);
    OBPOSTCONDITION(GraySecureURLImage != nil);
    OBPOSTCONDITION(GrayGeneratedURLImage != nil);
    OBPOSTCONDITION(GraySecureGeneratedURLImage != nil);
    OBPOSTCONDITION(GrayURLBookmarkImage != nil);
    OBPOSTCONDITION(GrayURLIndexImage != nil);
    ImagesSetup = YES;
}

+ (NSImage *)urlImage;
{
    return URLImage;
}

- (NSImage *)drawImage;
{
    if (!ImagesSetup)
	[isa setupImages];

    if ([self isSecure]) {
        if ([self isAlwaysUnique])
            return SecureGeneratedURLImage;
        else
            return SecureURLImage;
    } else {
        if ([self isAlwaysUnique]) {
            return GeneratedURLImage;
        } else {
            switch (effect) {
                case OWAddressEffectOpenBookmarksWindow:
                    return URLBookmarkImage;
                case OWAddressEffectOpenSearchWindow:
                    return URLIndexImage;
                default:
                    return URLImage;
            }
        }
    }
}

- (NSImage *)grayDrawImage;
{
    if (!ImagesSetup)
	[isa setupImages];

    if ([self isSecure]) {
        if ([self isAlwaysUnique])
            return GraySecureGeneratedURLImage;
        else
            return GraySecureURLImage;
    } else {
        if ([self isAlwaysUnique]) {
            return GrayGeneratedURLImage;
        } else {
            switch (effect) {
                case OWAddressEffectOpenBookmarksWindow:
                    return GrayURLBookmarkImage;
                case OWAddressEffectOpenSearchWindow:
                    return GrayURLIndexImage;
                default:
                    return GrayURLImage;
            }
        }
    }
}

#define X_SPACE_BETWEEN_ICON_AND_TEXT_BOX 2
#define X_TEXT_BOX_BORDER 2
#define Y_TEXT_BOX_BORDER 2

- (NSImage *)dragImage;
{
    NSImage *baseImage, *drawImage;
    NSSize imageSize, totalSize;
    NSString *title;
    NSSize titleSize, titleBoxSize;
    NSRect titleBox;
    NSPoint textPoint;

    baseImage = [self drawImage];
    OBASSERT(baseImage != nil);
    imageSize = [baseImage size];

    title = [self bestKnownTitle];
    if (!title || [title length] == 0)
        return baseImage;
    
    titleSize = [title sizeWithAttributes:titleFontAttributes];
    titleBoxSize = NSMakeSize(titleSize.width + 2.0 * X_TEXT_BOX_BORDER, titleSize.height + Y_TEXT_BOX_BORDER);

    totalSize = NSMakeSize(imageSize.width + X_SPACE_BETWEEN_ICON_AND_TEXT_BOX + titleBoxSize.width, MAX(imageSize.height, titleBoxSize.height));

    drawImage = [[NSImage alloc] initWithSize:totalSize];
    [drawImage setFlipped:YES];

    [drawImage lockFocus];

    // Draw transparent background
    [[NSColor colorWithDeviceWhite:1.0 alpha:0.0] set];
    NSRectFill(NSMakeRect(0, 0, totalSize.width, totalSize.height));

    // Draw icon
    [baseImage compositeToPoint:NSMakePoint(0.0, rint(totalSize.height / 2.0 + imageSize.height / 2.0)) operation:NSCompositeSourceOver];
    
    // Draw box around title
    titleBox = NSMakeRect(imageSize.width + X_SPACE_BETWEEN_ICON_AND_TEXT_BOX, floor((totalSize.height - titleBoxSize.height)/2.0), titleBoxSize.width, titleBoxSize.height);
    [[NSColor colorWithDeviceWhite:1.0 alpha:0.333] set];
    NSRectFill(titleBox);
    [[NSColor colorWithDeviceWhite:0.0 alpha:0.666] set];
    NSFrameRect(titleBox);

    // Draw title
    textPoint = NSMakePoint(imageSize.width + X_SPACE_BETWEEN_ICON_AND_TEXT_BOX + X_TEXT_BOX_BORDER, Y_TEXT_BOX_BORDER - 1);

    [title drawAtPoint:textPoint withAttributes:titleFontAttributes];

    [drawImage unlockFocus];

    return [drawImage autorelease];
}


@end
