// Copyright 1997-2000 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.
//
// $Header: /Network/Source/CVS/OmniGroup/Frameworks/OmniHTML/Support.subproj/OWAddress-OHPasteboard.h,v 1.5 2000/05/09 22:36:00 kc Exp $

#import <OWF/OWAddress.h>

@class NSPasteboard, NSImage;
@class OAPasteboardHelper;

@interface OWAddress (OHPasteboard)

+ (NSArray *)recognizedPasteboardTypes;
+ (NSString *)OWNewWindowURIType;

+ (OWAddress *)addressFromPasteboard:(NSPasteboard *)pasteboard;

// These are convenience methods for classes that implement the OAOutlineDragSupport protocol.  These are never called directly by OAOutlineView, but lots of the classes it calls call some of these

+ (NSArray *)acceptedPasteboardTypes;
+ (id)entryFromPropertyList:(id)propertyList ofType:(NSString *)type;
+ (NSImage *)dragImageForEntry:(id)anEntry;

+ (void)declareTypesForEntry:(id)anEntry pasteboardHelper:(OAPasteboardHelper *)pasteboardHelper;
+ (void)addTypesForEntry:(id)anEntry pasteboardHelper:(OAPasteboardHelper *)pasteboardHelper;
- (void)pasteboard:(NSPasteboard *)pasteboard provideDataForType:(NSString *)type;

- (NSArray *)exportedPasteboardTypes;
- (void)copyToGeneralPasteboard;

@end
