// Copyright 1997-2000 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.

#import <OmniHTML/OWAddress-OHPasteboard.h>

#import <Foundation/Foundation.h>
#import <AppKit/AppKit.h>
#import <OmniBase/OmniBase.h>
#import <OmniFoundation/OmniFoundation.h>
#import <OmniAppKit/OmniAppKit.h>
#import <OWF/OWF.h>

#import <OmniHTML/OWAddress-OHImage.h>

RCS_ID("$Header: /Network/Source/CVS/OmniGroup/Frameworks/OmniHTML/Support.subproj/OWAddress-OHPasteboard.m,v 1.11 2000/05/09 22:36:00 kc Exp $")

@interface OWAddress (OHPasteboardPrivate)
+ (void)setupPasteboardTypes;
@end

@implementation OWAddress (OHPasteboard)

static BOOL OWAddressPasteboardTypesSetup = NO;

static NSString *W3URI11PboardType = @"WebStep Universal Resource Identifier 1.1";
static NSString *W3URI11TitlePboardType = @"WebStep URI Descriptive Title 1.1";
static NSString *OWNewWindowURIType = @"OmniWeb URI Pasteboard only for new windows 1.0";

static NSArray *recognizedPasteboardTypes = nil;
static NSArray *basicExportedPasteboardTypes = nil;

+ (void)setupPasteboardTypes;
{
    if (OWAddressPasteboardTypesSetup)
	return;

    recognizedPasteboardTypes = [[NSArray alloc] initWithObjects:NSURLPboardType, W3URI11PboardType, NSFilenamesPboardType, NSStringPboardType, nil];

    // Note: These should be declared in order of preference (i.e., the ones that best represent us should come first in the array)
    basicExportedPasteboardTypes = [[NSArray alloc] initWithObjects:W3URI11PboardType, NSStringPboardType, NSURLPboardType, W3URI11TitlePboardType, nil];

    OWAddressPasteboardTypesSetup = YES;
}

+ (NSArray *)recognizedPasteboardTypes;
{
    if (!OWAddressPasteboardTypesSetup)
	[self setupPasteboardTypes];
    return recognizedPasteboardTypes;
}

+ (NSString *)OWNewWindowURIType;
{
    return OWNewWindowURIType;
}

//

+ (OWAddress *)addressFromPasteboard:(NSPasteboard *)pasteboard;
{
    NSString *type;
    id propertyList;

    if (!OWAddressPasteboardTypesSetup)
        [self setupPasteboardTypes];
    
    type = [pasteboard availableTypeFromArray:recognizedPasteboardTypes];

    propertyList = [pasteboard propertyListForType:type]; 

    if (!propertyList)
        return nil;
    return [self entryFromPropertyList:propertyList ofType:type];
}

// These are convenience methods for classes that implement the OAOutlineDragSupport protocol.  These are never called directly by OAOutlineView, but lots of the classes it calls call some of these

+ (NSArray *)acceptedPasteboardTypes;
{
    if (!OWAddressPasteboardTypesSetup)
        [self setupPasteboardTypes];
    return recognizedPasteboardTypes;
}

+ (id)entryFromPropertyList:propertyList ofType:(NSString *)type;
{
    if ([type isEqualToString:NSURLPboardType] || [type isEqualToString:NSFilenamesPboardType]) {
        if ([propertyList isKindOfClass:[NSArray class]] && [propertyList count] >= 1)
            return [self addressForDirtyString:[propertyList objectAtIndex:0]];
        else if ([propertyList isKindOfClass:[NSString class]] )
            return [self addressForDirtyString:propertyList];
    } else if ([type isEqualToString:W3URI11PboardType] || [type isEqualToString:NSStringPboardType]) {
        return [self addressForDirtyString:propertyList];
    }
    return nil;
}

+ (NSImage *)dragImageForEntry:(id)anEntry;
{
    return [anEntry dragImage];
}

// SOON TO BE OBSOLETE!
+ (void)declareTypesForEntry:(id)anEntry pasteboardHelper:(OAPasteboardHelper *)pasteboardHelper;
{
    [pasteboardHelper declareTypes:[anEntry exportedPasteboardTypes] owner:anEntry];
}

// SOON TO BE OBSOLETE!
+ (void)addTypesForEntry:(id)anEntry pasteboardHelper:(OAPasteboardHelper *)pasteboardHelper;
{
    [pasteboardHelper addTypes:[anEntry exportedPasteboardTypes] owner:anEntry];
}


// Used by new OAExtendedOutlineView (wjs 4/17/00)
- (NSArray *)exportedPasteboardTypes;
{
    if (!OWAddressPasteboardTypesSetup)
        [isa setupPasteboardTypes];

    if ([self localFilename] != nil)
        return [basicExportedPasteboardTypes arrayByAddingObject:NSFilenamesPboardType];
    else
        return basicExportedPasteboardTypes;
}


// NSPasteboardOwner

- (void)pasteboard:(NSPasteboard *)pasteboard provideDataForType:(NSString *)type;
{
    if ([type isEqualToString:NSURLPboardType]) {
        NSURL *appleUrl = [NSURL URLWithString:[self addressString]];

        [appleUrl writeToPasteboard:pasteboard];
    } else if ([type isEqualToString:W3URI11PboardType] || [type isEqualToString:NSStringPboardType] || [type isEqualToString:OWNewWindowURIType]) {
        [pasteboard setString:[self addressString] forType:type];
    } else if ([type isEqualToString:W3URI11TitlePboardType]) {
        NSString *title;

        title = [OWDocumentTitle titleForAddress:self];
        if (!title)
            title = [self addressString];
        [pasteboard setString:title forType:type];
    } else if ([type isEqualToString:NSFilenamesPboardType]) {
        [pasteboard setString:[self localFilename] forType:type];
    }
}

//

- (void)copyToGeneralPasteboard;
{
    OAPasteboardHelper *helper;
    NSPasteboard *pasteboard;
    NSEnumerator *enumerator;
    NSString *type;

    pasteboard = [NSPasteboard pasteboardWithName:NSGeneralPboard];
    helper = [[OAPasteboardHelper alloc] initWithPasteboard:pasteboard];

    [isa declareTypesForEntry:self pasteboardHelper:helper];
    // now force all the data onto the pasteboard since OpenStep/Windows 4.2pr2 has a major bug with changing the owner of the NSGeneralPboard, causing us to break otherwise
    enumerator = [[pasteboard types] objectEnumerator];
    while ((type = [enumerator nextObject]))
        [self pasteboard:pasteboard provideDataForType:type];

    [helper release];
}

@end
