// Copyright 1997-2000 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.
//
// $Header: /Network/Source/CVS/OmniGroup/Frameworks/OmniHTML/Tables.subproj/OHColumnSeparations.h,v 1.8 2000/03/25 06:34:49 wjs Exp $

#import <OmniFoundation/OFObject.h>

#import <OmniHTML/OHWidthRange.h>

@interface OHColumnSeparations : OFObject
{
@public
    unsigned int columnCount;
    OHWidthRange **columnSeparatorWidthRange;
}

- initWithColumnCount:(unsigned int)aColumnCount;
- (unsigned int)columnCount;
- (void)resetSeparations;
- (void)resetSeparationsWithColumnCount:(unsigned int)newColumnCount;

@end

static inline OHWidthRange *OHColumnSeparationsPointerToStoredWidthRangeBetweenColumns(OHColumnSeparations *separations, unsigned int leftColumn, unsigned int rightColumn)
{
    OBASSERT(separations != nil);
    OBASSERT(leftColumn < rightColumn);
    OBASSERT(rightColumn <= separations->columnCount);
    return &separations->columnSeparatorWidthRange[leftColumn][rightColumn - leftColumn - 1];
}

static inline OHWidthRange OHColumnSeparationsWidthRangeBetweenColumns(OHColumnSeparations *separations, unsigned int leftColumn, unsigned int rightColumn)
{
    OHWidthRange *storedWidthRange;

    storedWidthRange = OHColumnSeparationsPointerToStoredWidthRangeBetweenColumns(separations, leftColumn, rightColumn);
    return *storedWidthRange;
}

static inline unsigned int OHColumnSeparationsMinimumWidthBetweenColumns(OHColumnSeparations *separations, unsigned int leftColumn, unsigned int rightColumn)
{
    OHWidthRange *storedWidthRange;

    storedWidthRange = OHColumnSeparationsPointerToStoredWidthRangeBetweenColumns(separations, leftColumn, rightColumn);
    return storedWidthRange->minimum;
}

static inline unsigned int OHColumnSeparationsMaximumWidthBetweenColumns(OHColumnSeparations *separations, unsigned int leftColumn, unsigned int rightColumn)
{
    OHWidthRange *storedWidthRange;

    storedWidthRange = OHColumnSeparationsPointerToStoredWidthRangeBetweenColumns(separations, leftColumn, rightColumn);
    return storedWidthRange->maximum;
}

static inline void OHColumnSeparationsEnsureMinimumSeparationWidthRangeBetweenColumns(OHColumnSeparations *separations, OHWidthRange aRange, unsigned int leftColumn, unsigned int rightColumn)
{
    OHWidthRange *storedWidthRange;

    storedWidthRange = OHColumnSeparationsPointerToStoredWidthRangeBetweenColumns(separations, leftColumn, rightColumn);
    *storedWidthRange = OHMaximumWidthRange(*storedWidthRange, aRange);
}

static inline void OHColumnSeparationsRequestWidthBetweenColumns(OHColumnSeparations *separations, unsigned int requestedWidth, unsigned int leftColumn, unsigned int rightColumn)
{
    OHWidthRange *storedWidthRange;

    storedWidthRange = OHColumnSeparationsPointerToStoredWidthRangeBetweenColumns(separations, leftColumn, rightColumn);
    if (requestedWidth < storedWidthRange->minimum)
        requestedWidth = storedWidthRange->minimum;
    storedWidthRange->minimum = requestedWidth;
    storedWidthRange->maximum = requestedWidth;
}
