// Copyright 1997-2000 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.

#import "OHColumnSeparations.h"

#import <Foundation/Foundation.h>
#import <OmniBase/OmniBase.h>
#import <OmniFoundation/OmniFoundation.h>
#import <OWF/OWF.h>

RCS_ID("$Header: /Network/Source/CVS/OmniGroup/Frameworks/OmniHTML/Tables.subproj/OHColumnSeparations.m,v 1.6 2000/01/20 00:28:01 kc Exp $")

@implementation OHColumnSeparations

// Init and dealloc

- initWithColumnCount:(unsigned int)aColumnCount;
{
    if (![super init])
        return nil;

    [self resetSeparationsWithColumnCount:aColumnCount];

    return self;
}

- (void)dealloc;
{
    NSZoneFree([self zone], columnSeparatorWidthRange);
    [super dealloc];
}

// Declared methods

- (unsigned int)columnCount;
{
    return columnCount;
}

- (void)resetSeparations;
{
    OHWidthRange zeroWidthRange;
    unsigned int leftIndex, rightIndex;

    zeroWidthRange = OHMakeWidthRange(0, 0);
    for (leftIndex = 0; leftIndex < columnCount; leftIndex++) {
        for (rightIndex = leftIndex + 1; rightIndex <= columnCount; rightIndex++) {
            OHWidthRange *storedWidthRange;

            storedWidthRange = OHColumnSeparationsPointerToStoredWidthRangeBetweenColumns(self, leftIndex, rightIndex);
            *storedWidthRange = zeroWidthRange;
        }
    }
}

- (void)resetSeparationsWithColumnCount:(unsigned int)newColumnCount;
{
    if (columnSeparatorWidthRange == NULL || columnCount != newColumnCount) {
        unsigned int mallocSize;
        unsigned int subarrayIndex;
        void *mallocedSpace;
        OHWidthRange *freeSpace;

        if (columnSeparatorWidthRange != NULL)
            NSZoneFree([self zone], columnSeparatorWidthRange);

        columnCount = newColumnCount;
        mallocSize = columnCount * sizeof(*columnSeparatorWidthRange) + columnCount * (columnCount + 1) / 2 * sizeof(**columnSeparatorWidthRange);
        mallocedSpace = NSZoneMalloc([self zone], mallocSize);
        columnSeparatorWidthRange = mallocedSpace;
        freeSpace = (void *)(columnSeparatorWidthRange + columnCount);
        for (subarrayIndex = 0; subarrayIndex < columnCount; subarrayIndex++) {
            columnSeparatorWidthRange[subarrayIndex] = freeSpace;
            freeSpace += (columnCount - subarrayIndex);
        }
        OBPOSTCONDITION((void *)freeSpace == mallocedSpace + mallocSize);
    }
    [self resetSeparations];
}

// Debugging

- (NSMutableDictionary *)debugDictionary;
{
    NSMutableDictionary *debugDictionary;
    unsigned int leftIndex, rightIndex;

    debugDictionary = [super debugDictionary];

    [debugDictionary setObject:[NSString stringWithFormat:@"%d", columnCount] forKey:@"columnCount"];
    for (leftIndex = 0; leftIndex < columnCount; leftIndex++)
        for (rightIndex = leftIndex + 1; rightIndex <= columnCount; rightIndex++)
            [debugDictionary setObject:OHStringFromWidthRange(OHColumnSeparationsWidthRangeBetweenColumns(self, leftIndex, rightIndex)) forKey:[NSString stringWithFormat:@"separation[%02d][%02d]", leftIndex, rightIndex]];

    return debugDictionary;
}

@end
