// Copyright 1997-2000 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.

#import <OmniHTML/OHHTMLDisplayProcessor.h>

#import <Foundation/Foundation.h>
#import <OmniBase/OmniBase.h>
#import <OmniFoundation/OmniFoundation.h>
#import <OWF/OWF.h>

#import <OmniHTML/OWSGMLDTD-OHHTMLDTD.h>
#import <OmniHTML/OHTable.h>
#import <OmniHTML/OHTextBuilder.h>
#import <OmniHTML/OHHTMLDocument.h>

#import "OHTableBuilder.h"
#import "OHTableContainerCell.h"

RCS_ID("$Header: /Network/Source/CVS/OmniGroup/Frameworks/OmniHTML/Tables.subproj/OHHTMLDisplayProcessor-Tables.m,v 1.11 2000/03/25 06:34:49 wjs Exp $")

@implementation OHHTMLDisplayProcessor (Tables)

+ (void)didLoad;
{
    OWSGMLMethods *methods;
    unsigned int tableTagIndex;

    static NSString *tableTags[] = {
	@"tr", @"td", @"th", @"caption",
#ifdef SPEC_SUPPORT
	@"hspec", @"vspec",
#endif
#if 0
	@"tbody", @"thead", @"tfoot",
#endif
	nil
    };

    methods = [self sgmlMethods];

    [methods registerMethod:@"Table" forTagName:@"table"];

    for (tableTagIndex = 0; tableTags[tableTagIndex]; tableTagIndex++) {
        [methods registerSelector:@selector(processTableContentTag:) forTagName:tableTags[tableTagIndex]];
        [methods registerSelector:@selector(processTableContentTag:) forEndTagName:tableTags[tableTagIndex]];
    }
}

- (void)processTableTag:(OWSGMLTag *)tag
{
    OHTableBuilder *oldTableBuilder;
    NSAutoreleasePool *pool;
    OHTableContainerCell *tableCell;
    NSString *alignmentString;
    BOOL shouldCenter = NO;

    pool = [[NSAutoreleasePool alloc] init];

    oldTableBuilder = tableBuilder;

    // Create a new table builder and process the table's content
    tableBuilder = [[OHTableBuilder allocWithZone:[self zone]] initWithProcessor:self tag:tag];
    [self processContentForTag:tag];
    [tableBuilder endBuilding];
    
    tableCell = [[OHTableContainerCell allocWithZone:[htmlDocument zone]] initWithTable:[tableBuilder table]];

    // Alignment
    alignmentString = sgmlTagValueForAttributeAtIndex(tag, tableAlignAttributeIndex);
    switch ([alignmentString firstCharacter]) {
        case 'c': // Center
        case 'C':
            shouldCenter = YES;
            break;
        default: // Cell alignment
            [tableCell setAlignmentString:sgmlTagValueForAttributeAtIndex(tag, tableAlignAttributeIndex)];
            break;
    }

    // Inset size
    [tableCell setInsetSizeWidthString:sgmlTagValueForAttributeAtIndex(tag, tableHSpaceAttributeIndex) heightString:sgmlTagValueForAttributeAtIndex(tag, tableVSpaceAttributeIndex) defaultWidth:([tableCell isMarginalCell] ? 1.0 : 0.0)];

    if (![tableCell isMarginalCell]) {
        [textBuilder ensureAtStartOfLine];
        if (shouldCenter)
            [textBuilder startCentering];
    }
    [textBuilder writeNonWhitespaceCellObject:tableCell];
    if (![tableCell isMarginalCell]) {
        [textBuilder ensureAtStartOfLine];
        if (shouldCenter)
            [textBuilder stopCentering];
    }

    [tableCell release];

    [tableBuilder release];
    tableBuilder = oldTableBuilder;

    [pool release];
}

- (void)processTableContentTag:(OWSGMLTag *)tag
{
    [tableBuilder processTag:tag];
}

@end

