// Copyright 1997-2000 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.
//
// $Header: /Network/Source/CVS/OmniGroup/Frameworks/OmniHTML/Tables.subproj/OHRowSeparations.h,v 1.5 2000/01/20 00:28:01 kc Exp $

#import <OmniFoundation/OFObject.h>

@interface OHRowSeparations : OFObject
{
@public
    unsigned int rowCount;
    unsigned int **rowSeparatorDistance;
}

- initWithRowCount:(unsigned int)aRowCount;
- (unsigned int)rowCount;
- (void)resetSeparations;

@end

#import <OmniBase/assertions.h>

static inline unsigned int *OHRowSeparationsPointerToStoredDistanceBetweenRows(OHRowSeparations *separations, unsigned int topRow, unsigned int bottomRow)
{
    OBASSERT(separations != nil);
    OBASSERT(topRow < bottomRow);
    OBASSERT(bottomRow <= separations->rowCount);
    return &separations->rowSeparatorDistance[topRow][bottomRow - topRow - 1];
}

static inline unsigned int OHRowSeparationsDistanceBetweenRows(OHRowSeparations *separations, unsigned int topRow, unsigned int bottomRow)
{
    unsigned int *storedDistance;

    storedDistance = OHRowSeparationsPointerToStoredDistanceBetweenRows(separations, topRow, bottomRow);
    return *storedDistance;
}

static inline void OHRowSeparationsEnsureDistanceBetweenRows(OHRowSeparations *separations, unsigned int aDistance, unsigned int topRow, unsigned int bottomRow)
{
    unsigned int *storedDistance;

    storedDistance = OHRowSeparationsPointerToStoredDistanceBetweenRows(separations, topRow, bottomRow);
    if (aDistance > *storedDistance)
        *storedDistance = aDistance;
}
