// Copyright 1997-2000 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.

#import "OHRowSeparations.h"

#import <Foundation/Foundation.h>
#import <OmniBase/OmniBase.h>
#import <OmniFoundation/OmniFoundation.h>
#import <OWF/OWF.h>

RCS_ID("$Header: /Network/Source/CVS/OmniGroup/Frameworks/OmniHTML/Tables.subproj/OHRowSeparations.m,v 1.4 2000/01/20 00:28:01 kc Exp $")

@implementation OHRowSeparations

// Init and dealloc

- initWithRowCount:(unsigned int)aRowCount;
{
    unsigned int mallocSize;
    unsigned int subarrayIndex;
    void *mallocedSpace;
    unsigned int *freeSpace;

    if (![super init])
        return nil;

    rowCount = aRowCount;
    mallocSize = rowCount * sizeof(*rowSeparatorDistance) + rowCount * (rowCount + 1) / 2 * sizeof(**rowSeparatorDistance);
    mallocedSpace = NSZoneMalloc([self zone], mallocSize);
    rowSeparatorDistance = mallocedSpace;
    freeSpace = (void *)(rowSeparatorDistance + rowCount);
    for (subarrayIndex = 0; subarrayIndex < rowCount; subarrayIndex++) {
        rowSeparatorDistance[subarrayIndex] = freeSpace;
        freeSpace += (rowCount - subarrayIndex);
    }
    OBPOSTCONDITION((void *)freeSpace == mallocedSpace + mallocSize);
    [self resetSeparations];

    return self;
}

- (void)dealloc;
{
    NSZoneFree([self zone], rowSeparatorDistance);
    [super dealloc];
}

// Declared methods

- (unsigned int)rowCount;
{
    return rowCount;
}

- (void)resetSeparations;
{
    unsigned int topIndex, bottomIndex;

    for (topIndex = 0; topIndex < rowCount; topIndex++) {
        for (bottomIndex = topIndex + 1; bottomIndex <= rowCount; bottomIndex++) {
            unsigned int *storedDistance;

            storedDistance = OHRowSeparationsPointerToStoredDistanceBetweenRows(self, topIndex, bottomIndex);
            *storedDistance = 0;
        }
    }
}

// Debugging

- (NSMutableDictionary *)debugDictionary;
{
    NSMutableDictionary *debugDictionary;
    unsigned int topIndex, bottomIndex;

    debugDictionary = [super debugDictionary];

    [debugDictionary setObject:[NSString stringWithFormat:@"%d", rowCount] forKey:@"rowCount"];
    for (topIndex = 0; topIndex < rowCount; topIndex++)
        for (bottomIndex = topIndex + 1; bottomIndex <= rowCount; bottomIndex++)
            [debugDictionary setObject:[NSString stringWithFormat:@"%d", OHRowSeparationsDistanceBetweenRows(self, topIndex, bottomIndex)] forKey:[NSString stringWithFormat:@"separation[%02d][%02d]", topIndex, bottomIndex]];

    return debugDictionary;
}

@end
