// Copyright 1997-2000 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.
//
// $Header: /Network/Source/CVS/OmniGroup/Frameworks/OmniHTML/Tables.subproj/OHTable.h,v 1.11 2000/03/25 06:34:49 wjs Exp $

#import <AppKit/NSView.h>

@class NSMutableArray;
@class OFMatrix, OFSparseArray;
@class OHHTMLDisplayProcessor, OHHTMLOwner, OHColumnSeparations, OHTableCellHTMLView, OHTableContainerCell;

typedef enum {
    OWTL_WidthProportional,
} OWTLayoutType;

typedef enum {
    OWTD_Flat, OWTD_Gray, OWTD_Colored, OWTD_Textured
} OWTDisplayStyle;

typedef enum {
    OWTBorderNone = 0x00,	// No border at all
    OWTBorderFrame = 0x01,	// Outline around the table
    OWTBorderSections = 0x02,	// Between head/body and body/foot
    OWTBorderRows = 0x04,	// Between each row
    OWTBorderColumns = 0x08,	// Between each column
    OWTBorderAll = 0x0f,	// All forms of border
} OWTBorderType;

#import <OmniAppKit/OAFindControllerTargetProtocol.h>
#import <OmniHTML/OHHTMLPageContentProtocol.h>
#import <OmniHTML/OHWidthRange.h>

@interface OHTable : NSView <OHHTMLPageContent, OASearchableContent>
{
    OHTableContainerCell *nonretainedContainingTextCell;

    NSColor *backgroundColor;

    OFMatrix *dataCells;
    NSMutableArray *dataCellOwners;
    unsigned int columnCount;
    unsigned int selectionHoldingCellIndexHint;
    unsigned int firstBodyRow, lastBodyRow;

    // Layout parameters; see also the flags
    float requestedWidth, requestedHeight;
    OFSparseArray *columnRequests; // very inefficient
    OHColumnSeparations *columnSeparations;

    // Displaying

    OHWidthRange widthRange;
    float availableWidth, displayWidth;
    float visibleHeight;

    struct {
        OHWidthRange positionRange;	// Width range to column separator
        unsigned int separatorWidth;	// Width of the column separator
	unsigned int placement;		// Position of left of separator
    } *columnLayout;
    struct {
        unsigned int height;		// Height of the row separator
	unsigned int placement;		// Position of top of row separator
    } *rowLayout;
    unsigned int topMargin, bottomMargin;  // Space allowed for caption
    unsigned int captionOffset;

    unsigned int borderBits;  // OR of OWTBorderType(s)
    float borderWidth;
    float cellSpacing;  // i.e. internal border width

    OWTLayoutType layout;

    struct {
        unsigned int columnSeparationsValid:1;
        unsigned int widthsValid:1;
        unsigned int columnLayoutValid:1;
        unsigned int rowLayoutValid:1;
        unsigned int subviewsPositioned:1;
        unsigned int mungingFrames:1;
        unsigned int availableWidthValid:1;
        unsigned int displayWidthValid:1;
        unsigned int ignoreRequestedColumnWidths:1;

        // Requested size
        unsigned int haveRequestedWidth:1;
        unsigned int requestedWidthIsFraction:1;
        unsigned int haveRequestedHeight:1;
        unsigned int requestedHeightIsRelative:1;
    } tableFlags;

    OWTDisplayStyle displayStyle;
}

- init;
    // Designated initializer.  The standard NSView initializer, -initWithFrame:, is not allowed (since the frame is determined dynamically).

- (void)setBackgroundColor:(NSColor *)newBackgroundColor;
- (void)setBorderType:(int)type;
- (void)setBorderWidth:(float)newWidth;
- (void)setCellSpacing:(float)newSpacing;

- (void)setTableWidth:(float)newWidth isFraction:(BOOL)isFraction;
- (void)setTableHeight:(float)newHeight isFraction:(BOOL)isFraction;
- (void)setWidth:(unsigned int)columnWidth isFraction:(BOOL)isFraction forColumn:(unsigned int)columnIndex span:(unsigned int)columnSpan;

- (void)setDisplayStyle:(OWTDisplayStyle)newStyle;

- (void)acceptTableCellOwner:(OHHTMLOwner *)newCellOwner;

- (OHTableCellHTMLView *)cellAtRow:(unsigned int)rowIndex column:(unsigned int)columnIndex;

// Displaying

- (OHWidthRange)widthRange;
- (OFMatrix *)dataCells;

- (void)setContainingTextCell:(OHTableContainerCell *)aTextCell;
- (void)setLayoutSize:(NSSize)newSize;
- (float)currentDisplayWidth;
- (float)currentDisplayHeight;

- (NSRect)cellFrameForTableCell:(OHTableCellHTMLView *)tableCell;

- (BOOL)wantsRelayout;
    // Not currently called by anyone

// Informal OmniFindControllerAware protocol
- (id <OAFindControllerTarget>)omniFindControllerTarget;

@end
