// Copyright 1997-2000 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.
//
// $Header: /Network/Source/CVS/OmniGroup/Frameworks/OmniHTML/Tables.subproj/OHTableBuilder.h,v 1.8 2000/03/25 06:34:49 wjs Exp $

#import <OmniFoundation/OFObject.h>

@class NSMutableArray;
@class OFMatrix;
@class OWSGMLTag;
@class OHColorPalette, OHHTMLOwner, OHHTMLDisplayProcessor, OHTable, OHTableCellHTMLView, OHTextBuilder;

#import <OmniHTML/OHBasicCell.h>

@interface OHTableBuilder : OFObject
{
    OHTable *table;
    OHHTMLDisplayProcessor *htmlProcessor;

    OHTextBuilder *oldBuilder, *cellBuilder;
    OHHTMLOwner *currentCellOwner;
    OHTableCellHTMLView *currentCellHTMLView;

#ifdef SPEC_SUPPORT
    NSMutableArray *specs;
#endif
    OWSGMLTag *rowTag, *tableTag;

    unsigned int cellsThisRow;
    unsigned int currentRow;
    struct {
        unsigned int cellIsReal:1;
        unsigned int rowIsReal:1;
        unsigned int implicitCellsOK:1;
        unsigned int tableHasBackgroundColor:1;
    } flags;

    OFMatrix *cellBitmap;
    OHColorPalette *tableColorPalette;
    float cellPadding;
}

- initWithProcessor:(OHHTMLDisplayProcessor *)aProcessor tag:(OWSGMLTag *)aTableTag;

- (OHTable *)table;
- (void)processTag:(OWSGMLTag *)tag;
- (void)endBuilding;

@end

#import <OmniHTML/FrameworkDefines.h>

OmniHTML_PRIVATE_EXTERN unsigned int tableAlignAttributeIndex;
OmniHTML_PRIVATE_EXTERN unsigned int tableHSpaceAttributeIndex;
OmniHTML_PRIVATE_EXTERN unsigned int tableVSpaceAttributeIndex;
