// Copyright 1997-2000 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.
//
// $Header: /Network/Source/CVS/OmniGroup/Frameworks/OmniHTML/Tables.subproj/OHTableCellHTMLView.h,v 1.10 2000/03/25 06:34:49 wjs Exp $

#import <OmniHTML/OHHTMLView.h>

typedef enum {
    OHTableCellVerticalAlignTop,
    OHTableCellVerticalAlignMiddle,
    OHTableCellVerticalAlignBottom,
    OHTableCellVerticalAlignBaseline
} OHTableCellVerticalAlignment;

typedef struct {
    int left, right, top, bottom;
} OHTableCellBorders;

typedef enum {
    CellType_None = -1, CellType_Data, CellType_Header, CellType_Caption
} OHTableCellType;

typedef enum {
    OWTCW_None, OWTCW_Absolute, OWTCW_Relative
} OHTableCellWidthType;

@class OHTable;

@interface OHTableCellHTMLView : OHHTMLView
{
    unsigned int rowIndex;
    unsigned int columnIndex;
    unsigned int rowSpan;
    unsigned int columnSpan;
    OHTableCellVerticalAlignment verticalAlignment;
    OHTableCellType type;

    unsigned int requestedWidth;
    OHTableCellWidthType widthType;
}

- (unsigned int)rowIndex;
- (void)setRowIndex:(unsigned int)aRowIndex;
- (unsigned int)columnIndex;
- (void)setColumnIndex:(unsigned int)aColumnIndex;
- (unsigned int)rowSpan;
- (void)setRowSpan:(unsigned int)aRowSpan;
- (unsigned int)columnSpan;
- (void)setColumnSpan:(unsigned int)aColumnSpan;

- (OHTable *)table;
- (OHTableCellBorders)borders;
    // All of the above information, collected into one structure

- (OHTableCellVerticalAlignment)verticalAlignment;
- (void)setVerticalAlignment:(OHTableCellVerticalAlignment)anAlignment;

- (OHTableCellType)cellType;
- (void)setCellType:(OHTableCellType)newType;

- (OHTableCellWidthType)widthType;
- (unsigned int)requestedWidth;
- (void)requestWidth:(unsigned int)width isFraction:(BOOL)isFraction;

- (BOOL)isEmpty;
    // Returns YES if this cell contains no characters

@end

