// Copyright 1997-2000 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.

#import"OHTableCellHTMLView.h"

#import <Foundation/Foundation.h>
#import <AppKit/AppKit.h>
#import <OmniBase/OmniBase.h>
#import <OmniFoundation/OmniFoundation.h>
#import <OmniAppKit/OmniAppKit.h>
#import <OWF/OWF.h>

#import <OmniHTML/OHColorPalette.h>
#import <OmniHTML/OHHTMLDisplayProcessor.h>
#import <OmniHTML/OHHTMLPageView.h>
#import <OmniHTML/OHHTMLView.h>
#import <OmniHTML/OHTable.h>

#import "OHTableCellHTMLView.h"

RCS_ID("$Header: /Network/Source/CVS/OmniGroup/Frameworks/OmniHTML/Tables.subproj/OHTableCellHTMLView.m,v 1.15 2000/03/25 06:34:49 wjs Exp $")

@implementation OHTableCellHTMLView

- (id)initWithHTMLOwner:(OHHTMLOwner *)anHTMLOwner;
{
    if (![super initWithHTMLOwner:anHTMLOwner])
        return nil;

    rowIndex = 0;
    columnIndex = 0;
    rowSpan = 1;
    columnSpan = 1;
    verticalAlignment = OHTableCellVerticalAlignMiddle;
    type = CellType_Data;
    requestedWidth = 0;
    widthType = OWTCW_None;
    
    [self setAutoresizingMask:NSViewHeightSizable];

    return self;
}

- (unsigned int)rowIndex;
{
    return rowIndex;
}

- (void)setRowIndex:(unsigned int)aRowIndex;
{
    rowIndex = aRowIndex;
}

- (unsigned int)columnIndex;
{
    return columnIndex;
}

- (void)setColumnIndex:(unsigned int)aColumnIndex;
{
    columnIndex = aColumnIndex;
}

- (unsigned int)rowSpan;
{
    return rowSpan;
}

- (void)setRowSpan:(unsigned int)aRowSpan;
{
    // Check that the rowspan is reasonable (except for captions which don't do rowspans)
    if ((aRowSpan < 1 || aRowSpan > 8000) && type != CellType_Caption) {
        NSLog(@"Unlikely row span: %d", aRowSpan);
        aRowSpan = 1;
    }
    rowSpan = aRowSpan;
}

- (unsigned int)columnSpan;
{
    return columnSpan;
}

- (void)setColumnSpan:(unsigned int)aColumnSpan;
{
    if (aColumnSpan < 1 || aColumnSpan > 500) {
        NSLog(@"Unlikely column span: %d", aColumnSpan);
        aColumnSpan = 1;
    }
    columnSpan = aColumnSpan;
}

- (OHCellAlignment)verticalAlignment;
{
    return verticalAlignment;
}

- (void)setVerticalAlignment:(OHCellAlignment)anAlignment;
{
    verticalAlignment = anAlignment;
}

- (OHTableCellType)cellType;
{
    return type;
}

- (void)setCellType:(OHTableCellType)newType;
{
    type = newType;
}

//

- (OHTableCellWidthType)widthType;
{
    return widthType;
}

- (unsigned int)requestedWidth;
{
    return requestedWidth;
}

- (void)requestWidth:(unsigned int)width isFraction:(BOOL)isFraction;
{
    requestedWidth = width;
    widthType = isFraction ? OWTCW_Relative : OWTCW_Absolute;
}

//

- (BOOL)isEmpty;
{
    return [textStorage length] == 0;
}

// 

- (OHTable *)table;
{
    return (OHTable *)[self superview];
}

- (OHTableCellBorders)borders;
{
    OHTableCellBorders borders;

    borders.left = columnIndex;
    borders.right = columnIndex + columnSpan;
    borders.top = rowIndex;
    borders.bottom = rowIndex + rowSpan;
    
    return borders;
}

// OHHTMLView subclass

- (BOOL)drawsBackground;
{
    return [super drawsBackground] && ![self isEmpty];
}

- (NSSize)pageSize;
{
    // TODO: replace the 0 with the height if we support setting table heights directly
    return NSMakeSize(NSWidth([self bounds]), 0.0);
}

- (void)laidOutContentsAtSize:(NSSize)contentSize;
{
    NSSize currentSize, proposedSize;

    // We only count the textContainerInset for both the left and the right margin.
    proposedSize.height = contentSize.height + textContainerInset.height * 2.0;
    proposedSize.width = contentSize.width + textContainerInset.width * 2.0;

    currentSize = [self frame].size;
    // Should convert proposedSize to superview coordinates
    if (!NSEqualSizes(currentSize, proposedSize)) {
        // Don't change our width (our table does that), but do change our height
        [self setFrameSize:NSMakeSize(currentSize.width, proposedSize.height) relayout:NO];

        // Notify our table that we want to be resized
        [[self table] cachedWidthsAreInvalid];
    }
}


// OHHTMLPageContent protocol (overrides OHHTMLView implementation)

- (void)relayout;
{
    [super relayout];
    [[self table] cachedWidthsAreInvalid];
}

// Informal OmniFindControllerAware protocol

- (id <OAFindControllerTarget>)omniFindControllerTarget;
{
    return [[self table] omniFindControllerTarget];
}

@end

@implementation OHTableCellHTMLView (SubclassesOnly)

- (void)backgroundImageDidUpdate;
{
    [super backgroundImageDidUpdate];
    // We need to invalidate at least our cell, because the our bounds actually don't fill the cell in all cases, so the table draws our background for us.
    [[self table] setNeedsDisplay:YES];
}

@end


@implementation OHTableCellHTMLView (Private)

// Debugging methods

- (NSMutableDictionary *)debugDictionary;
{
    NSMutableDictionary *debugDictionary;

    debugDictionary = [super debugDictionary];

    [debugDictionary setObject:[NSString stringWithFormat:@"%d", columnSpan] forKey:@"columnSpan"];
    [debugDictionary setObject:[NSString stringWithFormat:@"%d", rowSpan] forKey:@"rowSpan"];

    return debugDictionary;
}

@end
