// Copyright 1997-2000 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.
//
// $Header: /Network/Source/CVS/OmniGroup/Frameworks/OmniHTML/Tables.subproj/OHTableColumnWidthRequest.h,v 1.4 2000/01/20 00:28:02 kc Exp $

#import <OmniFoundation/OFObject.h>

@interface OHTableColumnWidthRequest : OFObject
{
    struct {
        unsigned int hasFixedWidth:1;
        unsigned int hasPercentageWidth:1;
    } flags;
    unsigned int fixedWidth;
    unsigned int percentageWidth;
}

- (BOOL)hasFixedWidth;
- (unsigned int)fixedWidth;
- (void)requestFixedWidth:(unsigned int)newFixedWidth;
- (BOOL)hasPercentageWidth;
- (unsigned int)percentageWidth;
- (void)requestPercentageWidth:(unsigned int)newPercentageWidth;

@end
