// Copyright 1997-2000 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.

#import"OHTableColumnWidthRequest.h"

#import <Foundation/Foundation.h>
#import <OmniBase/OmniBase.h>
#import <OmniFoundation/OmniFoundation.h>
#import <OWF/OWF.h>

RCS_ID("$Header: /Network/Source/CVS/OmniGroup/Frameworks/OmniHTML/Tables.subproj/OHTableColumnWidthRequest.m,v 1.4 2000/03/25 06:34:49 wjs Exp $")

@implementation OHTableColumnWidthRequest

- init;
{
    if (![super init])
        return nil;

    flags.hasFixedWidth = NO;
    flags.hasPercentageWidth = NO;

    return self;
}

- (BOOL)hasFixedWidth;
{
    return flags.hasFixedWidth;
}

- (unsigned int)fixedWidth;
{
    OBASSERT(flags.hasFixedWidth);
    return fixedWidth;
}

- (void)requestFixedWidth:(unsigned int)newFixedWidth;
{
    if (flags.hasFixedWidth) {
        // Larger requests override previous requests
        if (newFixedWidth > fixedWidth)
            fixedWidth = newFixedWidth;
    } else {
        fixedWidth = newFixedWidth;
        flags.hasFixedWidth = YES;
    }
}

- (BOOL)hasPercentageWidth;
{
    return flags.hasPercentageWidth;
}

- (unsigned int)percentageWidth;
{
    OBASSERT(flags.hasPercentageWidth);
    return percentageWidth;
}

- (void)requestPercentageWidth:(unsigned int)newPercentageWidth;
{
    if (flags.hasPercentageWidth) {
        // Larger requests override previous requests
        if (newPercentageWidth > fixedWidth)
            percentageWidth = newPercentageWidth;
    } else {
        percentageWidth = newPercentageWidth;
        flags.hasPercentageWidth = YES;
    }
}

// Debugging

- (NSMutableDictionary *)debugDictionary;
{
    NSMutableDictionary *debugDictionary;

    debugDictionary = [super debugDictionary];
    if (flags.hasFixedWidth)
        [debugDictionary setObject:[NSString stringWithFormat:@"%d", fixedWidth] forKey:@"fixedWidth"];
    if (flags.hasPercentageWidth)
        [debugDictionary setObject:[NSString stringWithFormat:@"%d", percentageWidth] forKey:@"percentageWidth"];
    return debugDictionary;
}

@end
