// Copyright 1997-2000 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.

#import "OHTableContainerCell.h"

#import <Foundation/Foundation.h>
#import <AppKit/AppKit.h>
#import <OmniBase/OmniBase.h>
#import <OmniFoundation/OmniFoundation.h>
#import <OmniAppKit/OmniAppKit.h>
#import <OWF/OWF.h>

#import <OmniHTML/OHTable.h>
#import <OmniHTML/OHHTMLView.h>

RCS_ID("$Header: /Network/Source/CVS/OmniGroup/Frameworks/OmniHTML/Tables.subproj/OHTableContainerCell.m,v 1.7 2000/03/25 06:34:49 wjs Exp $")

@implementation OHTableContainerCell

- initWithTable:(OHTable *)aTable;
{
    if (![super init])
	return nil;

    table = [aTable retain];
    tableTextCellFlags.doingLayout = NO;
    [table setContainingTextCell:self];

    return self;
}

- (void)dealloc;
{
    [table setContainingTextCell:nil];
    [table release];
    [super dealloc];
}

- (OHTable *)table;
{
    return table;
}

// OHViewCell subclass

- (void)setupContentView;
{
    [self setContentView:table];
}

// OHBasicCell subclass

- (NSSize)contentSizeInLayoutBounds:(NSRect)layoutBounds;
{
    NSSize naturalSize;

    OBASSERT(!tableTextCellFlags.doingLayout);
    if (tableTextCellFlags.doingLayout)
        return NSMakeSize(4, 4);

    tableTextCellFlags.doingLayout = YES;
    naturalSize = NSMakeSize([table currentDisplayWidth], [table currentDisplayHeight]);
    tableTextCellFlags.doingLayout = NO;
    return naturalSize;
}

- (void)setLayoutBounds:(NSRect)bounds;
{
    [table setLayoutSize:bounds.size];
    [super setLayoutBounds:bounds];
}

- (OHWidthRange)widthRange;
{
    return [table widthRange];
}

- (BOOL)trackMouse:(NSEvent *)event inHTMLView:(OHHTMLView *)htmlView;
{
    return YES;
}

// OASearchableContent hints

- (NSView <OASearchableContent> *)searchableContentView;
{
    return table;
}

// Debugging

- (NSMutableDictionary *)debugDictionary;
{
    NSMutableDictionary *debugDictionary;

    debugDictionary = [super debugDictionary];
    if (table)
	[debugDictionary setObject:table forKey:@"table"];
    return debugDictionary;
}

@end
