// Copyright 1998-2000 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.
//
// $Header: /Network/Source/CVS/OmniGroup/Frameworks/OmniHTML/View.subproj/OHAbstractTextRow.h,v 1.9 2000/03/25 06:34:01 wjs Exp $

#import <OmniFoundation/OFStaticObject.h>

@class NSParagraphStyle;
@class OHHTMLView;

#import <Foundation/NSGeometry.h> // For NSRect, etc.
#import <Foundation/NSRange.h>
#import <OmniHTML/OHBasicCell.h>

@interface OHAbstractTextRow : OFStaticObject
{
@public
    NSRange wordRange;
    NSRect bounds;
    float maxAscent;
}

- (NSParagraphStyle *)paragraphStyleInHTMLView:(OHHTMLView *)htmlView;

@end

@interface OHAbstractTextRow (SubclassesOnly)
- (void)getLineHeightAndAscentForAttributes:(NSDictionary **)attributes attributesRange:(NSRange *)attributesRange inHTMLView:(OHHTMLView *)htmlView;

- (void)getMaxAscent:(float *)ascent andMaxDescent:(float *)descent forAttachmentCell:(OHBasicCell *)attachmentCell baselineOffset:(float)baselineOffset attributes:(NSDictionary *)attributes;
@end
