// Copyright 1997-2000 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.
//
// $Header: /Network/Source/CVS/OmniGroup/Frameworks/OmniHTML/View.subproj/OHHTMLAnchor.h,v 1.15 2000/03/25 06:34:01 wjs Exp $

// An OHHTMLAnchor represents one hot spot in one document.

#import <OmniHTML/OHHTMLLink.h>

@class NSMutableArray;
@class NSColor, NSTextStorage;
@class OHColorPalette, OHHTMLView;

#import <Foundation/NSRange.h>
#import <OmniHTML/OHBasicCell.h>
#import <OmniHTML/OHColorPalette.h> // For OHColorPaletteIndex

@interface OHHTMLAnchor : OHHTMLLink
{
    OHHTMLView *nonretainedHTMLView;
    NSRange characterRange;
    NSMutableArray *nonretainedContainedMarginalCells;

    OHColorPalette *colorPalette;
    NSColor *lastColor;
    struct {
        unsigned int hasOverrideColor:1;
    } flags;
}

- initWithColorPalette:(OHColorPalette *)aColorPalette;

// Our location
- (OHHTMLView *)htmlView;
- (void)setHTMLView:(OHHTMLView *)newHTMLView;
- (NSRange)range;
- (void)setRange:(NSRange)aRange;
- (void)addContainedCell:(OHBasicCell *)newContainingCell;
- (void)removeContainedCell:(OHBasicCell *)newContainingCell;
- (const NSRect *)rectArrayAndCount:(unsigned int *)returnRectCountPtr;
- (NSRect)containingRect;
- (NSRect)containingRectForScroll;
- (BOOL)mouseInAnchorAtPoint:(NSPoint)aPoint;

//
- (OHColorPalette *)colorPalette;
- (void)setColorPalette:(OHColorPalette *)aColorPalette;
- (BOOL)hasOverrideColor;
- (void)setHasOverrideColor;
- (OHColorPaletteIndex)colorIndex;
- (NSColor *)color;
- (void)updateColor;

- (NSString *)label; // For dragging

// Scrolling
- (void)scrollToTop;
- (void)scrollToVisible;

@end
