// Copyright 1997-2000 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.
//
// $Header: /Network/Source/CVS/OmniGroup/Frameworks/OmniHTML/View.subproj/OHHTMLDocument.h,v 1.13 2000/03/25 06:34:01 wjs Exp $

#import <OmniHTML/OHHTMLOwner.h>

@class NSLock, NSArray, NSMutableArray;
@class OHForm, OHViewCell, OHHTMLPageView, OHColorPalette, OHInlineImageCell, OHAppletCell;
@class OWPipeline;
@class OWScriptContext, OWScriptDocumentProxy;

#import <OmniHTML/OHDocumentProtocol.h>
#import <OmniHTML/OHFormElementProtocol.h>

@interface OHHTMLDocument : OHHTMLOwner <OHDocument>
{
    OWContentInfo *contentInfo;

    NSLock *documentInfoLock;  /* protects "htmlOwners", "forms", "documentColorPalette", and "documentImages" */

    NSMutableArray *htmlOwners;
    NSMutableArray *forms;
    OHViewCell *firstFormKeyElement;
    OHViewCell *lastFormKeyElement;

    // The document's color palette. The only reason to keep this around is that it's visible from JavaScript.
    OHColorPalette *documentColorPalette;

    // A list of the images in the document, for use by scripts.
    NSMutableArray *documentImages;

    // A list of the applets in the document, for use by scripts.
    NSMutableArray *documentApplets;

    BOOL havePostedLoadEvent;
}

- (OHHTMLPageView *)htmlPageView;

// Building the document
- (void)addHTMLOwner:(OHHTMLOwner *)anHTMLOwner;
- (void)addForm:(OHForm *)aForm;
- (OHViewCell *)firstFormKeyElement;
- (OHViewCell *)lastFormKeyElement;
- (void)setPipeline:(OWPipeline *)myPipe;

// Scripting interaction
- (OWScriptDocumentProxy *)scriptProxy;
- (NSArray *)forms;
    // Returns a snapshot of the forms array
- (OHColorPalette *)colorPalette;
- (void)setColorPalette:(OHColorPalette *)aPalette;
- (NSArray *)images;
- (void)addImage:(OHInlineImageCell *)anImage;
- (NSArray *)applets;
- (void)addApplet:(OHAppletCell *)anApplet;

@end
