// Copyright 1998-2000 Omni Development, Inc.  All rights reserved.
//
// This software may only be used and reproduced according to the
// terms in the file OmniSourceLicense.html, which should be
// distributed with this project and can also be found at
// http://www.omnigroup.com/DeveloperResources/OmniSourceLicense.html.
//
// $Header: /Network/Source/CVS/OmniGroup/Frameworks/OmniHTML/View.subproj/OHHTMLLink.h,v 1.4 2000/02/24 00:04:48 kc Exp $

// An OHHTMLLink represents one hypertext link, currently either an anchor or an image-map region

#import <OmniFoundation/OFObject.h>

@class NSEvent;
@class OWAddress, OWScriptEvent, OWScriptEventHandlerHolder;

@interface OHHTMLLink : OFObject
{
    NSString *name;
    OWAddress *address;
    OWScriptEventHandlerHolder *eventHandlers;
}

- (OWAddress *)address;
- (void)setAddress:(OWAddress *)anAddress;

- (NSString *)name;
- (void)setName:(NSString *)aString;

- (NSString *)label;

- (OWScriptEventHandlerHolder *)eventHandlers;

// Drawing
- (void)setColorToIndex:(unsigned int)newColorIndex;
- (void)invalidateDisplay;
- (void)invalidateDisplayIncludingBorderOfWidth:(float)borderWidth;

// Scripting
- (void)followFromEvent:(NSEvent *)event;
- (void)followFromScriptEvent:(OWScriptEvent *)scriptEvent;

@end
